/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.intercept.CountInterceptor;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.ExistsByInterceptor;
import io.micronaut.data.intercept.FindAllInterceptor;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.FindOptionalInterceptor;
import io.micronaut.data.intercept.FindPageInterceptor;
import io.micronaut.data.intercept.FindSliceInterceptor;
import io.micronaut.data.intercept.FindStreamInterceptor;
import io.micronaut.data.intercept.SaveAllInterceptor;
import io.micronaut.data.intercept.SaveEntityInterceptor;
import io.micronaut.data.intercept.SaveOneInterceptor;
import io.micronaut.data.intercept.UpdateAllEntitiesInterceptor;
import io.micronaut.data.intercept.UpdateEntityInterceptor;
import io.micronaut.data.intercept.UpdateInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.intercept.async.CountAsyncInterceptor;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.intercept.async.DeleteOneAsyncInterceptor;
import io.micronaut.data.intercept.async.ExistsByAsyncInterceptor;
import io.micronaut.data.intercept.async.FindAllAsyncInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.async.FindPageAsyncInterceptor;
import io.micronaut.data.intercept.async.FindSliceAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveAllAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveEntityAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveOneAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateAllEntriesAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateEntityAsyncInterceptor;
import io.micronaut.data.intercept.reactive.CountReactiveInterceptor;
import io.micronaut.data.intercept.reactive.DeleteAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.DeleteOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.ExistsByReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindPageReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindSliceReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveEntityReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateAllEntitiesReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateEntityReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateReactiveInterceptor;
import io.micronaut.data.model.Slice;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

@Internal
public interface FindersUtils {
    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveInterceptorTypeByOperationType(boolean hasEntityParameter, boolean hasMultipleEntityParameter, DataMethod.OperationType operationType, MethodMatchContext matchContext) {
        ClassElement returnType = matchContext.getMethodElement().getGenericReturnType();
        switch (operationType) {
            case DELETE: {
                if (hasEntityParameter) {
                    return FindersUtils.pickDeleteInterceptor(matchContext, returnType);
                }
                return FindersUtils.pickDeleteAllInterceptor(matchContext, returnType);
            }
            case UPDATE: {
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> updateEntry = hasMultipleEntityParameter ? FindersUtils.pickUpdateAllEntitiesInterceptor(matchContext, returnType) : (hasEntityParameter ? FindersUtils.pickUpdateEntityInterceptor(matchContext, returnType) : FindersUtils.pickUpdateInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(updateEntry.getKey(), Iterable.class)) {
                    return FindersUtils.typeAndInterceptorEntry((ClassElement)updateEntry.getKey().getFirstTypeArgument().orElseThrow(IllegalStateException::new), updateEntry.getValue());
                }
                return updateEntry;
            }
            case INSERT: {
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> saveEntry = hasEntityParameter ? FindersUtils.pickSaveEntityInterceptor(matchContext, returnType) : (hasMultipleEntityParameter ? FindersUtils.pickSaveAllEntitiesInterceptor(matchContext, returnType) : FindersUtils.pickSaveOneInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(saveEntry.getKey(), Iterable.class)) {
                    return FindersUtils.typeAndInterceptorEntry((ClassElement)saveEntry.getKey().getFirstTypeArgument().orElseThrow(IllegalStateException::new), saveEntry.getValue());
                }
                return saveEntry;
            }
            case QUERY: 
            case COUNT: 
            case EXISTS: {
                return FindersUtils.resolveFindInterceptor(matchContext, returnType);
            }
        }
        throw new IllegalStateException("Cannot pick interceptor for an operation type: " + operationType + " and a return type: " + returnType);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickSaveOneInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), SaveOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), SaveOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveOneInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickUpdateAllEntitiesInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), UpdateAllEntriesAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), UpdateAllEntitiesReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), UpdateAllEntitiesInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickDeleteInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), DeleteOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), DeleteOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), DeleteOneInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickDeleteAllInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), DeleteAllAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), DeleteAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), DeleteAllInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickSaveEntityInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), SaveEntityAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), SaveEntityReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveEntityInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickSaveAllEntitiesInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), SaveAllAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), SaveAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveAllInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickUpdateInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), UpdateAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), UpdateReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), UpdateInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickUpdateEntityInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), UpdateEntityAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), UpdateEntityReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), UpdateEntityInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveFindInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.isFutureType(matchContext.getMethodElement(), returnType) ? FindersUtils.resolveAsyncFindInterceptor(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType)) : (FindersUtils.isReactiveType(returnType) ? FindersUtils.resolveReactiveFindInterceptor(matchContext, returnType, (ClassElement)returnType.getFirstTypeArgument().orElseThrow(IllegalStateException::new)) : FindersUtils.resolveSyncFindInterceptor(matchContext, returnType));
        return entry;
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveSyncFindInterceptor(@NonNull MethodMatchContext matchContext, @NotNull ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindPageInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindSliceInterceptor.class);
        }
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindAllInterceptor.class);
        }
        if (FindersUtils.isContainer(returnType, Stream.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindStreamInterceptor.class);
        }
        if (FindersUtils.isContainer(returnType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindOptionalInterceptor.class);
        }
        if (FindersUtils.isContainer(returnType, Publisher.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType, FindOneInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReactiveFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement returnType, @NonNull ClassElement reactiveType) {
        ClassElement firstTypeArgument = reactiveType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isPage(matchContext, reactiveType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindPageReactiveInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, reactiveType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindSliceReactiveInterceptor.class);
        }
        if (FindersUtils.isReactiveSingleResult(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(reactiveType, FindOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(reactiveType, FindAllReactiveInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveAsyncFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement asyncType) {
        ClassElement firstTypeArgument = asyncType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isPage(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindPageAsyncInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindSliceAsyncInterceptor.class);
        }
        if (FindersUtils.isContainer(asyncType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindAllAsyncInterceptor.class);
        }
        if (FindersUtils.isContainer(asyncType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindOneAsyncInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(asyncType, FindOneAsyncInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickCountInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), CountAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), CountReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), CountInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickExistsInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), ExistsByAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), ExistsByReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), ExistsByInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickFindByIdInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindByIdAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindByIdReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindByIdInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickFindOneInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindOneInterceptor.class);
    }

    public static Map.Entry<ClassElement, ClassElement> pickCountSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.CountAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.CountReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.CountSpecificationInterceptor"));
    }

    public static Map.Entry<ClassElement, ClassElement> pickDeleteAllSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.DeleteAllAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.DeleteAllReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.DeleteAllSpecificationInterceptor"));
    }

    public static Map.Entry<ClassElement, ClassElement> pickFindAllSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindAllAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindAllReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindAllSpecificationInterceptor"));
    }

    public static Map.Entry<ClassElement, ClassElement> pickFindOneSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindOneAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindOneReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindOneSpecificationInterceptor"));
    }

    public static Map.Entry<ClassElement, ClassElement> pickFindPageSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindPageAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindPageReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindPageSpecificationInterceptor"));
    }

    public static Map.Entry<ClassElement, ClassElement> pickUpdateAllSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.UpdateAllAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.UpdateAllReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.UpdateAllSpecificationInterceptor"));
    }

    public static Map.Entry<ClassElement, ClassElement> pickExistsSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.ExistsAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry((ClassElement)returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.ExistsReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.ExistsSpecificationInterceptor"));
    }

    public static ClassElement getAsyncType(@NonNull MethodElement methodElement, @NonNull ClassElement returnType) {
        if (methodElement.isSuspend()) {
            return TypeUtils.getKotlinCoroutineProducedType(methodElement);
        }
        return returnType.getFirstTypeArgument().orElse(null);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> typeAndInterceptorEntry(ClassElement type, Class<? extends DataInterceptor> interceptor) {
        return new AbstractMap.SimpleEntry<ClassElement, Class<? extends DataInterceptor>>(type, interceptor);
    }

    public static Map.Entry<ClassElement, ClassElement> typeAndInterceptorEntry(ClassElement type, ClassElement interceptor) {
        return new AbstractMap.SimpleEntry<ClassElement, ClassElement>(type, interceptor);
    }

    public static boolean isFutureType(MethodElement methodElement, @Nullable ClassElement type) {
        return methodElement.isSuspend() || FindersUtils.isOneOfContainers(type, CompletionStage.class, Future.class);
    }

    public static boolean isReactiveType(@Nullable ClassElement type) {
        return FindersUtils.isContainer(type, Publisher.class) || TypeUtils.isReactiveType(type) && (type.getTypeArguments().isEmpty() || FindersUtils.isContainer(type, type.getName()));
    }

    public static boolean isPage(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "page");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return matches;
    }

    public static boolean isSlice(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "slice");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return FindersUtils.isContainer(typeArgument, Slice.class);
    }

    public static boolean isContainer(ClassElement typeArgument, Class<?> containerType) {
        if (typeArgument == null) {
            return false;
        }
        if (typeArgument.isAssignable(containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                throw new MatchFailedException("'" + containerType + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isOneOfContainers(ClassElement typeArgument, Class<?> ... containers) {
        if (typeArgument == null) {
            return false;
        }
        for (Class<?> containerType : containers) {
            if (!FindersUtils.isContainer(typeArgument, containerType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainer(ClassElement typeArgument, String containerType) {
        if (typeArgument.isAssignable(containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                throw new MatchFailedException("'" + containerType + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isValidResultType(ClassElement returnType) {
        return returnType.hasStereotype(Introspected.class) || ClassUtils.isJavaBasicType((String)returnType.getName()) || returnType.isPrimitive();
    }

    public static boolean isReactiveSingleResult(ClassElement returnType) {
        return returnType.hasStereotype(SingleResult.class) || FindersUtils.isContainer(returnType, "io.reactivex.Single") || FindersUtils.isContainer(returnType, "reactor.core.publisher.Mono");
    }

    public static ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, Class<? extends DataInterceptor> type) {
        return matchContext.getVisitorContext().getClassElement(type).orElseGet(() -> new DynamicClassElement(type));
    }

    public static ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, String type) {
        return (ClassElement)matchContext.getVisitorContext().getClassElement(type).orElseThrow(() -> new IllegalStateException("Unable to apply interceptor of type: " + type + ". The interceptor was not found on the classpath. Check your annotation processor configuration and try again."));
    }

    public static class DynamicClassElement
    implements ClassElement {
        private final Class<? extends DataInterceptor> type;

        DynamicClassElement(Class<? extends DataInterceptor> type) {
            this.type = type;
        }

        public boolean isAssignable(String type) {
            return false;
        }

        public ClassElement toArray() {
            return new DynamicClassElement(Array.newInstance(this.type, 0).getClass());
        }

        public ClassElement fromArray() {
            return new DynamicClassElement(this.type.getComponentType());
        }

        @NonNull
        public String getName() {
            return this.type.getName();
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.type.getModifiers());
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.type.getModifiers());
        }

        @NonNull
        public Object getNativeType() {
            return this.type;
        }
    }
}

