/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.impl.SourceParameterExpressionImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.Utils;
import io.micronaut.data.processor.visitors.finders.DeleteMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RawQueryMethodMatcher
implements MethodMatcher {
    private static final String SELECT = "select";
    private static final String DELETE = "delete";
    private static final String UPDATE = "update";
    private static final String INSERT = "insert";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("([^:\\\\]*)((?<![:]):([a-zA-Z0-9]+))([^:]*)");

    @Override
    public final int getOrder() {
        return -1000;
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (matchContext.getMethodElement().stringValue(Query.class).isPresent()) {
            return new MethodMatcher.MethodMatch(){

                @Override
                public MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
                    ParameterElement entitiesParameter;
                    ParameterElement entityParameter;
                    MethodElement methodElement = matchContext.getMethodElement();
                    ParameterElement[] parameters = matchContext.getParameters();
                    if (parameters.length > 1) {
                        entityParameter = null;
                        entitiesParameter = null;
                    } else {
                        entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
                        entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
                    }
                    boolean readOnly = matchContext.getAnnotationMetadata().booleanValue(Query.class, "readOnly").orElse(true);
                    String query = (String)matchContext.getAnnotationMetadata().stringValue(Query.class).orElseThrow(IllegalStateException::new);
                    DataMethod.OperationType operationType = RawQueryMethodMatcher.this.findOperationType(methodElement.getName(), query, readOnly);
                    Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, operationType, matchContext);
                    ClassElement resultType = entry.getKey();
                    Class<? extends DataInterceptor> interceptorType = entry.getValue();
                    if (interceptorType.getSimpleName().startsWith("SaveOne")) {
                        operationType = DataMethod.OperationType.UPDATE;
                        Map.Entry<ClassElement, Class<? extends DataInterceptor>> e = FindersUtils.pickUpdateInterceptor(matchContext, matchContext.getReturnType());
                        resultType = e.getKey();
                        interceptorType = e.getValue();
                    }
                    if (operationType == DataMethod.OperationType.QUERY) {
                        entityParameter = null;
                        entitiesParameter = null;
                    }
                    boolean isDto = false;
                    if (resultType == null) {
                        resultType = matchContext.getRootEntity().getType();
                    } else if (operationType == DataMethod.OperationType.QUERY) {
                        if (resultType.hasAnnotation(Introspected.class) && !resultType.hasAnnotation(MappedEntity.class)) {
                            isDto = true;
                        }
                    } else if (!RawQueryMethodMatcher.this.isValidReturnType(resultType, operationType)) {
                        throw new MatchFailedException("Invalid result type: " + resultType.getName() + " for '" + operationType + "' operation");
                    }
                    MethodMatchInfo methodMatchInfo = new MethodMatchInfo(operationType, (TypedElement)resultType, FindersUtils.getInterceptorElement(matchContext, interceptorType));
                    methodMatchInfo.dto(isDto);
                    RawQueryMethodMatcher.this.buildRawQuery(matchContext, methodMatchInfo, entityParameter, entitiesParameter, operationType);
                    if (entityParameter != null) {
                        methodMatchInfo.addParameterRole("entity", entityParameter.getName());
                    } else if (entitiesParameter != null) {
                        methodMatchInfo.addParameterRole("entities", entitiesParameter.getName());
                    }
                    return methodMatchInfo;
                }
            };
        }
        return null;
    }

    private boolean isValidReturnType(ClassElement returnType, DataMethod.OperationType operationType) {
        if (operationType == DataMethod.OperationType.INSERT) {
            return TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType);
        }
        return true;
    }

    private DataMethod.OperationType findOperationType(String methodName, String query, boolean readOnly) {
        if ((query = query.trim().toLowerCase(Locale.ENGLISH)).startsWith(SELECT)) {
            return DataMethod.OperationType.QUERY;
        }
        if (query.startsWith(DELETE)) {
            return DataMethod.OperationType.DELETE;
        }
        if (query.startsWith(UPDATE)) {
            if (DeleteMethodMatcher.METHOD_PATTERN.matcher(methodName.toLowerCase(Locale.ENGLISH)).matches()) {
                return DataMethod.OperationType.DELETE;
            }
            return DataMethod.OperationType.UPDATE;
        }
        if (query.startsWith(INSERT)) {
            return DataMethod.OperationType.INSERT;
        }
        if (readOnly) {
            return DataMethod.OperationType.QUERY;
        }
        return DataMethod.OperationType.UPDATE;
    }

    private void buildRawQuery(@NonNull MethodMatchContext matchContext, MethodMatchInfo methodMatchInfo, ParameterElement entityParameter, ParameterElement entitiesParameter, DataMethod.OperationType operationType) {
        MethodElement methodElement = matchContext.getMethodElement();
        String queryString = (String)methodElement.stringValue(Query.class).orElseThrow(() -> new IllegalStateException("Should only be called if Query has value!"));
        List<ParameterElement> parameters = Arrays.asList(matchContext.getParameters());
        boolean namedParameters = matchContext.getRepositoryClass().booleanValue(RepositoryConfiguration.class, "namedParameters").orElse(true);
        ParameterElement entityParam = null;
        SourcePersistentEntity persistentEntity = null;
        if (entityParameter != null) {
            entityParam = entityParameter;
            persistentEntity = matchContext.getEntity(entityParameter.getGenericType());
        } else if (entitiesParameter != null) {
            entityParam = entitiesParameter;
            persistentEntity = matchContext.getEntity((ClassElement)entitiesParameter.getGenericType().getFirstTypeArgument().orElseThrow(IllegalStateException::new));
        }
        QueryResult queryResult = this.getQueryResult(matchContext, queryString, parameters, namedParameters, entityParam, persistentEntity);
        String cq = matchContext.getAnnotationMetadata().stringValue(Query.class, "countQuery").orElse(null);
        QueryResult countQueryResult = cq == null ? null : this.getQueryResult(matchContext, cq, parameters, namedParameters, entityParam, persistentEntity);
        boolean encodeEntityParameters = persistentEntity != null || operationType == DataMethod.OperationType.INSERT;
        methodMatchInfo.isRawQuery(true).encodeEntityParameters(encodeEntityParameters).queryResult(queryResult).countQueryResult(countQueryResult);
    }

    private QueryResult getQueryResult(MethodMatchContext matchContext, String queryString, List<ParameterElement> parameters, boolean namedParameters, ParameterElement entityParam, SourcePersistentEntity persistentEntity) {
        Matcher matcher = VARIABLE_PATTERN.matcher(queryString.replace("\\:", ""));
        final ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>(parameters.size());
        final ArrayList<String> queryParts = new ArrayList<String>();
        int index = 1;
        int lastOffset = 0;
        while (matcher.find()) {
            BindingParameter.BindingContext bindingContext;
            PersistentPropertyPath propertyPath;
            Optional<ParameterElement> element;
            String prefix = queryString.substring(lastOffset, matcher.start(3) - 1);
            if (!prefix.isEmpty()) {
                queryParts.add(prefix);
            }
            lastOffset = matcher.end(3);
            String name = matcher.group(3);
            if (namedParameters) {
                element = parameters.stream().filter(p -> p.stringValue(Parameter.class).orElse(p.getName()).equals(name)).findFirst();
                if (element.isPresent()) {
                    propertyPath = matchContext.getRootEntity().getPropertyPath(name);
                    bindingContext = BindingParameter.BindingContext.create().name(name).incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
                    parameterBindings.add(this.bindingParameter(matchContext, element.get()).bind(bindingContext));
                    continue;
                }
                if (persistentEntity != null) {
                    propertyPath = persistentEntity.getPropertyPath(name);
                    if (propertyPath == null) {
                        throw new MatchFailedException("Cannot update non-existent property: " + name);
                    }
                    bindingContext = BindingParameter.BindingContext.create().name(name).incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
                    parameterBindings.add(this.bindingParameter(matchContext, entityParam, true).bind(bindingContext));
                    continue;
                }
                throw new MatchFailedException("No method parameter found for named Query parameter: " + name);
            }
            element = parameters.stream().filter(p -> p.stringValue(Parameter.class).orElse(p.getName()).equals(name)).findFirst();
            if (element.isPresent()) {
                propertyPath = matchContext.getRootEntity().getPropertyPath(name);
                bindingContext = BindingParameter.BindingContext.create().index(index++).incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
                parameterBindings.add(this.bindingParameter(matchContext, element.get()).bind(bindingContext));
                continue;
            }
            if (persistentEntity != null) {
                propertyPath = persistentEntity.getPropertyPath(name);
                if (propertyPath == null) {
                    matchContext.fail("Cannot update non-existent property: " + name);
                    continue;
                }
                bindingContext = BindingParameter.BindingContext.create().index(index++).incomingMethodParameterProperty(propertyPath).outgoingQueryParameterProperty(propertyPath);
                parameterBindings.add(this.bindingParameter(matchContext, entityParam, true).bind(bindingContext));
                continue;
            }
            throw new MatchFailedException("No method parameter found for named Query parameter: " + name);
        }
        queryString = queryString.replace("\\:", ":");
        if (queryParts.isEmpty()) {
            queryParts.add(queryString);
        } else if (lastOffset > 0) {
            queryParts.add(queryString.substring(lastOffset));
        }
        final String finalQueryString = queryString;
        return new QueryResult(){

            public String getQuery() {
                return finalQueryString;
            }

            public List<String> getQueryParts() {
                return queryParts;
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    private SourceParameterExpressionImpl bindingParameter(MethodMatchContext matchContext, ParameterElement element) {
        return this.bindingParameter(matchContext, element, false);
    }

    private SourceParameterExpressionImpl bindingParameter(MethodMatchContext matchContext, ParameterElement element, boolean isEntityParameter) {
        return new SourceParameterExpressionImpl(Utils.getConfiguredDataTypes(matchContext.getRepositoryClass()), matchContext.getParameters(), element, isEntityParameter);
    }
}

