/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractPrefixPatternMethodMatcher
implements MethodMatcher {
    protected final Pattern pattern;

    protected AbstractPrefixPatternMethodMatcher(String ... prefixes) {
        if (ArrayUtils.isEmpty((Object[])prefixes)) {
            throw new IllegalArgumentException("At least one prefix required");
        }
        Arrays.sort(prefixes, Comparator.comparingInt(String::length).thenComparing(String::compareTo).reversed());
        this.pattern = AbstractPrefixPatternMethodMatcher.computePattern(prefixes);
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        String methodName = matchContext.getMethodElement().getName();
        Matcher matcher = this.pattern.matcher(methodName);
        if (matcher.find()) {
            return this.match(matchContext, matcher);
        }
        return null;
    }

    protected abstract MethodMatcher.MethodMatch match(MethodMatchContext var1, Matcher var2);

    private static Pattern computePattern(String[] prefixes) {
        String prefixPattern = String.join((CharSequence)"|", prefixes);
        return Pattern.compile("^((" + prefixPattern + ")(\\S*?))$");
    }
}

