/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPrefixPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;

public abstract class AbstractSpecificationMethodMatcher
extends AbstractPrefixPatternMethodMatcher {
    protected AbstractSpecificationMethodMatcher(String ... prefixes) {
        super(prefixes);
    }

    @Override
    public int getOrder() {
        return -200;
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (!this.isMatchesParameters(matchContext)) {
            return null;
        }
        return super.match(matchContext);
    }

    protected final ClassElement getInterceptorElement(MethodMatchContext matchContext, String interceptorType) {
        return FindersUtils.getInterceptorElement(matchContext, interceptorType);
    }

    protected boolean isMatchesParameters(MethodMatchContext matchContext) {
        return this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement(), matchContext) || this.isFirstParameterMicronautJpaSpecification(matchContext.getMethodElement());
    }

    private boolean isFirstParameterSpringJpaSpecification(MethodElement methodElement, MatchContext matchContext) {
        VisitorContext visitorContext = matchContext.getVisitorContext();
        if (visitorContext.getClassElement("io.micronaut.data.spring.jpa.intercept.CountSpecificationInterceptor").isPresent() && visitorContext.getClassElement("org.springframework.data.jpa.domain.Specification").isPresent()) {
            return this.isFirstParameterSpringJpaSpecification(methodElement);
        }
        return false;
    }

    protected final boolean isFirstParameterSpringJpaSpecification(@NonNull MethodElement methodElement) {
        return this.isFirstParameterAssignable(methodElement, "org.springframework.data.jpa.domain.Specification");
    }

    protected final boolean isFirstParameterMicronautJpaSpecification(@NonNull MethodElement methodElement) {
        return this.isFirstParameterAssignable(methodElement, "io.micronaut.data.jpa.repository.criteria.Specification");
    }

    protected final boolean isFirstParameterMicronautDataQuerySpecification(@NonNull MethodElement methodElement) {
        if (this.isFirstParameterMicronautDataPredicateSpecification(methodElement)) {
            return true;
        }
        return this.isFirstParameterAssignable(methodElement, "io.micronaut.data.repository.jpa.criteria.QuerySpecification");
    }

    protected final boolean isFirstParameterMicronautDataDeleteSpecification(@NonNull MethodElement methodElement) {
        if (this.isFirstParameterMicronautDataPredicateSpecification(methodElement)) {
            return true;
        }
        return this.isFirstParameterAssignable(methodElement, "io.micronaut.data.repository.jpa.criteria.DeleteSpecification");
    }

    protected final boolean isFirstParameterMicronautDataUpdateSpecification(@NonNull MethodElement methodElement) {
        if (this.isFirstParameterMicronautDataPredicateSpecification(methodElement)) {
            return true;
        }
        return this.isFirstParameterAssignable(methodElement, "io.micronaut.data.repository.jpa.criteria.UpdateSpecification");
    }

    private boolean isFirstParameterMicronautDataPredicateSpecification(@NonNull MethodElement methodElement) {
        return this.isFirstParameterAssignable(methodElement, "io.micronaut.data.repository.jpa.criteria.PredicateSpecification");
    }

    private boolean isFirstParameterAssignable(@NonNull MethodElement methodElement, String clazz) {
        ParameterElement[] parameters = methodElement.getParameters();
        return parameters.length > 0 && parameters[0].getType().isAssignable(clazz);
    }
}

