/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;

public class DeleteByMethod
extends DynamicFinder {
    protected static final String[] PREFIXES = new String[]{"delete", "remove", "erase", "eliminate"};

    public DeleteByMethod() {
        super(PREFIXES);
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.DELETE;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && TypeUtils.isValidBatchUpdateReturnType(methodElement);
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(MethodMatchContext matchContext, ClassElement queryResultType, @Nullable QueryModel query) {
        if (query == null) {
            matchContext.fail("Unable to implement delete method with no query arguments");
            return null;
        }
        return new MethodMatchInfo(null, query, this.getInterceptorElement(matchContext, FindersUtils.pickDeleteAllInterceptor(matchContext, matchContext.getReturnType()).getValue()), MethodMatchInfo.OperationType.DELETE);
    }
}

