/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.UpdateMethod;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpdateByMethod
extends DynamicFinder {
    public UpdateByMethod() {
        super("update");
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.UPDATE;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        boolean isMatch = super.isMethodMatch(methodElement, matchContext);
        if (isMatch) {
            if (!TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
                matchContext.possiblyFail("Update methods only support void or number based return types");
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean hasQueryAnnotation(@NonNull MethodElement methodElement) {
        String str = methodElement.stringValue(Query.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return str.trim().toLowerCase(Locale.ENGLISH).startsWith("update");
        }
        return false;
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        String[] updateProperties;
        if (query == null) {
            matchContext.fail("Cannot implement batch update operation that doesn't perform a query");
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getProjections())) {
            matchContext.fail("Projections are not supported on batch updates");
            return null;
        }
        if (!(query instanceof RawQuery)) {
            List criterionList = query.getCriteria().getCriteria();
            if (CollectionUtils.isEmpty((Collection)criterionList)) {
                matchContext.fail("Cannot implement batch update operation that doesn't perform a query");
                return null;
            }
            HashSet<String> queryParameters = new HashSet<String>();
            for (QueryModel.Criterion criterion : criterionList) {
                QueryModel.PropertyCriterion pc;
                Object v;
                if (!(criterion instanceof QueryModel.PropertyCriterion) || !((v = (pc = (QueryModel.PropertyCriterion)criterion).getValue()) instanceof QueryParameter)) continue;
                queryParameters.add(((QueryParameter)v).getName());
            }
            List updateParameters = matchContext.getParametersNotInRole().stream().filter(p -> !queryParameters.contains(p.getName())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(updateParameters)) {
                matchContext.fail("At least one parameter required to update");
                return null;
            }
            Element element = matchContext.getParametersInRole().get("lastUpdatedProperty");
            if (element instanceof PropertyElement) {
                updateParameters.add(element);
            }
            SourcePersistentEntity entity = matchContext.getRootEntity();
            updateProperties = new String[updateParameters.size()];
            for (int i = 0; i < updateProperties.length; ++i) {
                Element parameter = (Element)updateParameters.get(i);
                String parameterName = parameter.stringValue(Parameter.class).orElse(parameter.getName());
                Optional path = entity.getPath(parameterName);
                if (!path.isPresent()) {
                    matchContext.fail("Cannot perform batch update for non-existent property: " + parameterName);
                    return null;
                }
                updateProperties[i] = (String)path.get();
            }
        } else {
            updateProperties = StringUtils.EMPTY_STRING_ARRAY;
        }
        return new MethodMatchInfo((TypedElement)queryResultType, query, this.getInterceptorElement(matchContext, UpdateMethod.pickUpdateInterceptor(matchContext.getReturnType())), MethodMatchInfo.OperationType.UPDATE, updateProperties);
    }
}

