/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.UpdateEntityInterceptor;
import io.micronaut.data.intercept.async.UpdateEntityAsyncInterceptor;
import io.micronaut.data.intercept.reactive.UpdateEntityReactiveInterceptor;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.regex.Pattern;

public class UpdateEntityMethod
extends AbstractPatternBasedMethod
implements MethodCandidate {
    public static final Pattern METHOD_PATTERN = Pattern.compile("^((update)(\\S*?))$");

    public UpdateEntityMethod() {
        super(METHOD_PATTERN);
    }

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        ParameterElement[] parameters = matchContext.getParameters();
        return parameters.length == 1 && super.isMethodMatch(methodElement, matchContext) && UpdateEntityMethod.isValidSaveReturnType(matchContext, false);
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        VisitorContext visitorContext = matchContext.getVisitorContext();
        Object[] parameters = matchContext.getParameters();
        if (ArrayUtils.isNotEmpty((Object[])parameters) && Arrays.stream(parameters).anyMatch(p -> p.getGenericType().hasAnnotation(MappedEntity.class))) {
            ClassElement returnType = matchContext.getReturnType();
            Class<? extends DataInterceptor> interceptor = UpdateEntityMethod.pickSaveInterceptor(returnType);
            if (TypeUtils.isReactiveOrFuture(returnType)) {
                returnType = returnType.getGenericType().getFirstTypeArgument().orElse(returnType);
            }
            if (matchContext.supportsImplicitQueries()) {
                return new MethodMatchInfo((TypedElement)returnType, null, interceptor, MethodMatchInfo.OperationType.UPDATE, new String[0]);
            }
            SourcePersistentEntity rootEntity = matchContext.getRootEntity();
            QueryModel queryModel = QueryModel.from((PersistentEntity)rootEntity).idEq(new QueryParameter("id"));
            Object[] updateProperties = (String[])rootEntity.getPersistentProperties().stream().filter(p -> !(p instanceof Association) || !((Association)p).isForeignKey()).map(PersistentProperty::getName).toArray(String[]::new);
            if (ArrayUtils.isEmpty((Object[])updateProperties)) {
                return new MethodMatchInfo((TypedElement)returnType, null, interceptor, MethodMatchInfo.OperationType.UPDATE, new String[0]);
            }
            return new MethodMatchInfo((TypedElement)returnType, queryModel, interceptor, MethodMatchInfo.OperationType.UPDATE, (String[])updateProperties);
        }
        visitorContext.fail("Cannot implement save method for specified arguments and return type", (Element)matchContext.getMethodElement());
        return null;
    }

    static boolean isValidSaveReturnType(@NonNull MatchContext matchContext, boolean entityArgumentNotRequired) {
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(null);
        }
        return returnType != null && returnType.hasAnnotation(MappedEntity.class) && (entityArgumentNotRequired || returnType.getName().equals(matchContext.getParameters()[0].getGenericType().getName()));
    }

    @NonNull
    private static Class<? extends DataInterceptor> pickSaveInterceptor(@NonNull ClassElement returnType) {
        Class interceptor = TypeUtils.isFutureType(returnType) ? UpdateEntityAsyncInterceptor.class : (TypeUtils.isReactiveOrFuture(returnType) ? UpdateEntityReactiveInterceptor.class : UpdateEntityInterceptor.class);
        return interceptor;
    }
}

