/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PropertyElement;
import java.util.function.Function;

@Internal
class SourceAssociation
extends SourcePersistentProperty
implements Association {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;
    private final Relation.Kind kind;

    SourceAssociation(SourcePersistentEntity owner, PropertyElement propertyElement, @NonNull Function<ClassElement, SourcePersistentEntity> entityResolver) {
        super(owner, propertyElement);
        this.entityResolver = entityResolver;
        this.kind = super.getKind();
    }

    @NonNull
    public Relation.Kind getKind() {
        return this.kind;
    }

    public boolean isRequired() {
        return !this.isForeignKey() && super.isRequired();
    }

    @NonNull
    public PersistentEntity getAssociatedEntity() {
        ClassElement type = this.getType();
        switch (this.getKind()) {
            case ONE_TO_MANY: 
            case MANY_TO_MANY: {
                ClassElement classElement = type.getFirstTypeArgument().orElse(null);
                if (classElement != null) {
                    return this.entityResolver.apply(classElement);
                }
                throw new MappingException("Collection association [" + this.getName() + "] of entity [" + this.getOwner().getName() + "] does not specify a generic type argument");
            }
        }
        return this.entityResolver.apply(type);
    }
}

