/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.intercept.async.DeleteOneAsyncInterceptor;
import io.micronaut.data.intercept.reactive.DeleteAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.DeleteOneReactiveInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractListMethod;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;

public class DeleteMethod
extends AbstractListMethod {
    public DeleteMethod() {
        super("delete", "remove", "erase", "eliminate");
    }

    @Override
    public final int getOrder() {
        return 100;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && TypeUtils.isValidBatchUpdateReturnType(methodElement);
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        ParameterElement[] parameters = matchContext.getParameters();
        Class interceptor = null;
        if (parameters.length == 1) {
            SourcePersistentEntity rootEntity;
            ClassElement genericType = parameters[0].getGenericType();
            if (genericType.isAssignable((rootEntity = matchContext.getRootEntity()).getName())) {
                ClassElement returnType = matchContext.getReturnType();
                interceptor = TypeUtils.isFutureType(returnType) ? DeleteOneAsyncInterceptor.class : (TypeUtils.isReactiveType(returnType) ? DeleteOneReactiveInterceptor.class : DeleteOneInterceptor.class);
            } else if (TypeUtils.isIterableOfEntity(genericType)) {
                interceptor = DeleteMethod.pickDeleteAllInterceptor(matchContext.getReturnType());
            }
            if (interceptor != null) {
                if (matchContext.supportsImplicitQueries()) {
                    return new MethodMatchInfo(null, null, interceptor, MethodMatchInfo.OperationType.DELETE, new String[0]);
                }
                QueryModel queryModel = QueryModel.from((PersistentEntity)rootEntity);
                SourcePersistentProperty identity = rootEntity.getIdentity();
                if (identity == null) {
                    matchContext.fail("Delete all not supported for entities with no ID");
                    return null;
                }
                QueryParameter queryParameter = new QueryParameter(parameters[0].getName());
                if (interceptor.getSimpleName().startsWith("DeleteAll")) {
                    queryModel.inList(identity.getName(), queryParameter);
                } else {
                    queryModel.idEq(queryParameter);
                }
                return new MethodMatchInfo(null, queryModel, interceptor, MethodMatchInfo.OperationType.DELETE, new String[0]);
            }
        }
        return super.buildMatchInfo(matchContext);
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        Class<? extends DataInterceptor> interceptor = DeleteMethod.pickDeleteAllInterceptor(matchContext.getReturnType());
        if (query != null) {
            return new MethodMatchInfo(null, query, interceptor, MethodMatchInfo.OperationType.DELETE, new String[0]);
        }
        return new MethodMatchInfo(null, matchContext.supportsImplicitQueries() ? null : QueryModel.from((PersistentEntity)matchContext.getRootEntity()), interceptor, MethodMatchInfo.OperationType.DELETE, new String[0]);
    }

    static Class<? extends DataInterceptor> pickDeleteAllInterceptor(ClassElement returnType) {
        Class interceptor = TypeUtils.isFutureType(returnType) ? DeleteAllAsyncInterceptor.class : (TypeUtils.isReactiveType(returnType) ? DeleteAllReactiveInterceptor.class : DeleteAllInterceptor.class);
        return interceptor;
    }
}

