/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.convert.ConversionServiceProvider;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import org.reactivestreams.Publisher;

public interface ReactiveRepositoryOperations
extends ConversionServiceProvider {
    @NonNull
    @SingleResult
    public <T> Publisher<T> findOne(@NonNull Class<T> var1, @NonNull Object var2);

    @NonNull
    @SingleResult
    public <T> Publisher<Boolean> exists(@NonNull PreparedQuery<T, Boolean> var1);

    @NonNull
    @SingleResult
    public <T, R> Publisher<R> findOne(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    @SingleResult
    public <T> Publisher<T> findOptional(@NonNull Class<T> var1, @NonNull Object var2);

    @NonNull
    @SingleResult
    public <T, R> Publisher<R> findOptional(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T> Publisher<T> findAll(PagedQuery<T> var1);

    @NonNull
    @SingleResult
    public <T> Publisher<Long> count(PagedQuery<T> var1);

    @NonNull
    public <T, R> Publisher<R> findAll(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    @SingleResult
    public <T> Publisher<T> persist(@NonNull InsertOperation<T> var1);

    @NonNull
    @SingleResult
    public <T> Publisher<T> update(@NonNull UpdateOperation<T> var1);

    @NonNull
    public <T> Publisher<T> updateAll(@NonNull UpdateBatchOperation<T> var1);

    @NonNull
    public <T> Publisher<T> persistAll(@NonNull InsertBatchOperation<T> var1);

    @NonNull
    @SingleResult
    public Publisher<Number> executeUpdate(@NonNull PreparedQuery<?, Number> var1);

    @NonNull
    @SingleResult
    default public Publisher<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    @NonNull
    default public <R> Publisher<R> execute(@NonNull PreparedQuery<?, R> preparedQuery) {
        throw new DataAccessException("Current repository: " + this.getClass() + " doesn't support method 'execute'!");
    }

    @NonNull
    @SingleResult
    public <T> Publisher<Number> delete(@NonNull DeleteOperation<T> var1);

    @NonNull
    @SingleResult
    public <T> Publisher<Number> deleteAll(@NonNull DeleteBatchOperation<T> var1);

    @NonNull
    @SingleResult
    public <R> Publisher<Page<R>> findPage(@NonNull PagedQuery<R> var1);
}

