/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.annotation;

import io.micronaut.data.annotation.repeatable.JoinSpecifications;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
@Repeatable(value=JoinSpecifications.class)
public @interface Join {
    public String value();

    public Type type() default Type.FETCH;

    public String alias() default "";

    public static enum Type {
        DEFAULT,
        LEFT,
        LEFT_FETCH,
        RIGHT,
        RIGHT_FETCH,
        FETCH,
        INNER,
        OUTER,
        OUTER_FETCH;

        public static final EnumSet<Type> ALL_TYPES;

        public boolean isFetch() {
            return this.name().contains("FETCH");
        }

        static {
            ALL_TYPES = EnumSet.allOf(Type.class);
        }
    }
}

