/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.model.DefaultSlice;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@TypeHint(value={Slice.class})
@JsonDeserialize(as=DefaultSlice.class)
public interface Slice<T>
extends Iterable<T> {
    @NonNull
    public List<T> getContent();

    @NonNull
    public Pageable getPageable();

    default public int getPageNumber() {
        return this.getPageable().getNumber();
    }

    @NonNull
    default public Pageable nextPageable() {
        return this.getPageable().next();
    }

    @NonNull
    default public Pageable previousPageable() {
        return this.getPageable().previous();
    }

    default public long getOffset() {
        return this.getPageable().getOffset();
    }

    default public int getSize() {
        return this.getPageable().getSize();
    }

    default public boolean isEmpty() {
        return this.getContent().isEmpty();
    }

    @JsonIgnore
    @NonNull
    default public Sort getSort() {
        return this.getPageable();
    }

    default public int getNumberOfElements() {
        return this.getContent().size();
    }

    @Override
    @NonNull
    default public Iterator<T> iterator() {
        return this.getContent().iterator();
    }

    @NonNull
    default public <T2> Slice<T2> map(Function<T, T2> function) {
        List content = this.getContent().stream().map(function).collect(Collectors.toList());
        return new DefaultSlice(content, this.getPageable());
    }

    @ReflectiveAccess
    @NonNull
    public static <T2> Slice<T2> of(@NonNull List<T2> content, @NonNull Pageable pageable) {
        return new DefaultSlice<T2>(content, pageable);
    }
}

