/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.repository.jpa.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.repository.jpa.criteria.SpecificationComposition;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;

public interface PredicateSpecification<T> {
    public static final PredicateSpecification<?> ALL = (root, criteriaBuilder) -> null;

    @NonNull
    public static <T> PredicateSpecification<T> where(@Nullable PredicateSpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return spec;
    }

    @NonNull
    public static <T> PredicateSpecification<T> not(@Nullable PredicateSpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return (root, criteriaBuilder) -> criteriaBuilder.not((Expression)spec.toPredicate(root, criteriaBuilder));
    }

    @NonNull
    default public PredicateSpecification<T> and(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @NonNull
    default public PredicateSpecification<T> or(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Nullable
    public Predicate toPredicate(@NonNull Root<T> var1, @NonNull CriteriaBuilder var2);
}

