/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.Optional;

public interface Association
extends PersistentProperty {
    default public String getAliasName() {
        return NamingStrategy.DEFAULT.mappedName(this.getName()) + "_";
    }

    @NonNull
    public PersistentEntity getAssociatedEntity();

    default public Optional<? extends Association> getInverseSide() {
        return this.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").flatMap(s -> {
            PersistentProperty inverse = this.getAssociatedEntity().getPropertyByName((String)s);
            if (inverse instanceof Association) {
                return Optional.of((Association)inverse);
            }
            return Optional.empty();
        });
    }

    default public boolean isBidirectional() {
        return this.getInverseSide().isPresent();
    }

    @NonNull
    default public Relation.Kind getKind() {
        return this.findAnnotation(Relation.class).flatMap(av -> av.enumValue(Relation.Kind.class)).orElse(Relation.Kind.ONE_TO_ONE);
    }

    default public boolean isForeignKey() {
        Relation.Kind kind = this.getKind();
        return kind == Relation.Kind.ONE_TO_MANY || kind == Relation.Kind.MANY_TO_MANY || kind == Relation.Kind.ONE_TO_ONE && this.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent();
    }

    default public boolean doesCascade(Relation.Cascade ... types) {
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            String[] cascades;
            for (String cascade : cascades = this.getAnnotationMetadata().stringValues(Relation.class, "cascade")) {
                if (cascade.equals("ALL")) {
                    return true;
                }
                for (Relation.Cascade type : types) {
                    String n = type.name();
                    if (!n.equals(cascade)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

