/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.naming.NamingStrategies;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPersistentEntity
implements PersistentEntity {
    private static final Map<String, NamingStrategy> NAMING_STRATEGIES = new ConcurrentHashMap<String, NamingStrategy>(3);
    private final AnnotationMetadataProvider annotationMetadataProvider;
    private final NamingStrategy namingStrategy;

    protected AbstractPersistentEntity(AnnotationMetadataProvider annotationMetadataProvider) {
        this.annotationMetadataProvider = annotationMetadataProvider;
        AnnotationMetadata annotationMetadata = annotationMetadataProvider.getAnnotationMetadata();
        this.namingStrategy = this.getNamingStrategy(annotationMetadata);
    }

    @Override
    @NonNull
    public String getAliasName() {
        return NamingStrategy.DEFAULT.mappedName(this.getSimpleName()) + "_";
    }

    @NonNull
    private NamingStrategy getNamingStrategy(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.classValue(MappedEntity.class, "namingStrategy").flatMap(aClass -> {
            Object o = InstantiationUtils.tryInstantiate((Class)aClass).orElse(null);
            if (o instanceof NamingStrategy) {
                return Optional.of(o);
            }
            return Optional.empty();
        }).orElseGet(() -> annotationMetadata.stringValue(MappedEntity.class, "namingStrategy").flatMap(this::getNamingStrategy).orElse(new NamingStrategies.UnderScoreSeparatedLowerCase()));
    }

    @NonNull
    private Optional<NamingStrategy> getNamingStrategy(String name) {
        NamingStrategy namingStrategy = NAMING_STRATEGIES.get(name);
        if (namingStrategy != null) {
            return Optional.of(namingStrategy);
        }
        Object o = InstantiationUtils.tryInstantiate((String)name, (ClassLoader)this.getClass().getClassLoader()).orElse(null);
        if (o instanceof NamingStrategy) {
            NamingStrategy ns = o;
            NAMING_STRATEGIES.put(name, ns);
            return Optional.of(ns);
        }
        return Optional.empty();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadataProvider.getAnnotationMetadata();
    }

    @Override
    @NonNull
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    @NonNull
    public String getPersistedName() {
        return this.namingStrategy.mappedName(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        AbstractPersistentEntity that = (AbstractPersistentEntity)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

