/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateOperation;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public interface RepositoryOperations {
    @NonNull
    default public <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        return PersistentEntity.of(type);
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> var1, @NonNull Serializable var2);

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> var1);

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> var1);

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> var1);

    public <T> long count(PagedQuery<T> var1);

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> var1);

    public <R> Page<R> findPage(@NonNull PagedQuery<R> var1);

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> var1);

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> var1);

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull BatchOperation<T> var1);

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> var1);

    @NonNull
    default public Optional<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    public <T> Optional<Number> deleteAll(@NonNull BatchOperation<T> var1);

    @NonNull
    default public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        return Collections.emptyMap();
    }
}

