/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.api.MetricDescriptor;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.LoggerFactory;

public class ClearCustomMetricDescriptors {
    public static void clearCustomMetricDescriptors(MetricServiceSettings settings, String projectId) {
        try {
            MetricServiceClient client = MetricServiceClient.create((MetricServiceSettings)settings);
            Iterable listMetricDescriptorsPages = client.listMetricDescriptors(ListMetricDescriptorsRequest.newBuilder().setName("projects/" + projectId).setFilter("metric.type = starts_with(\"custom.googleapis.com/\")").build()).iteratePages();
            int deleted = 0;
            for (MetricServiceClient.ListMetricDescriptorsPage page : listMetricDescriptorsPages) {
                for (MetricDescriptor metricDescriptor : page.getValues()) {
                    System.out.println("deleting " + metricDescriptor.getName());
                    client.deleteMetricDescriptor(metricDescriptor.getName());
                    ++deleted;
                }
            }
            System.out.println("Deleted " + deleted + " custom metric descriptors");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        ((Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(Level.WARN);
        if (args.length == 0) {
            throw new IllegalArgumentException("Must provide a project id");
        }
        ClearCustomMetricDescriptors.clearCustomMetricDescriptors(MetricServiceSettings.newBuilder().build(), args[0]);
    }
}

