/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.requestmapping.custom;

import io.leopard.boot.requestmapping.custom.RequestHeaderMatcher;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class LeopardHttpHeaderRequestCondition
implements RequestCondition<LeopardHttpHeaderRequestCondition> {
    private Set<RequestHeaderMatcher> headerMatcherList;

    public LeopardHttpHeaderRequestCondition(Set<RequestHeaderMatcher> headerMatcherList) {
        this.headerMatcherList = headerMatcherList;
    }

    public LeopardHttpHeaderRequestCondition combine(LeopardHttpHeaderRequestCondition other) {
        LinkedHashSet<RequestHeaderMatcher> set = new LinkedHashSet<RequestHeaderMatcher>(this.headerMatcherList);
        set.addAll(other.headerMatcherList);
        return new LeopardHttpHeaderRequestCondition(set);
    }

    public boolean isFirstLookup() {
        for (RequestHeaderMatcher matcher : this.headerMatcherList) {
            if (!matcher.isFirstLookup()) continue;
            return true;
        }
        return false;
    }

    public LeopardHttpHeaderRequestCondition getMatchingCondition(HttpServletRequest request) {
        for (RequestHeaderMatcher headerMatcher : this.headerMatcherList) {
            boolean matched = headerMatcher.match(request);
            if (matched) continue;
            return null;
        }
        return this;
    }

    public int compareTo(LeopardHttpHeaderRequestCondition other, HttpServletRequest request) {
        return other.headerMatcherList.size() - this.headerMatcherList.size();
    }
}

