/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.informer.cache.Caches;
import io.kubernetes.client.informer.cache.Indexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class Cache<ApiType>
implements Indexer<ApiType> {
    private Function<ApiType, String> keyFunc;
    @Deprecated
    public static final String NAMESPACE_INDEX = "namespace";
    private Map<String, Function<ApiType, List<String>>> indexers = new HashMap<String, Function<ApiType, List<String>>>();
    private Map<String, ApiType> items = new HashMap<String, ApiType>();
    private Map<String, Map<String, Set<String>>> indices = new HashMap<String, Map<String, Set<String>>>();
    private ReentrantLock lock = new ReentrantLock();

    public Cache() {
        this(NAMESPACE_INDEX, Caches::metaNamespaceIndexFunc, Caches::deletionHandlingMetaNamespaceKeyFunc);
    }

    public Cache(String indexName, Function<ApiType, List<String>> indexFunc, Function<ApiType, String> keyFunc) {
        this.indexers.put(indexName, indexFunc);
        this.keyFunc = keyFunc;
        this.indices.put(indexName, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            ApiType oldObj = this.items.get(key);
            this.items.put(key, obj);
            this.updateIndices(oldObj, obj, key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            ApiType oldObj = this.items.get(key);
            this.items.put(key, obj);
            this.updateIndices(oldObj, obj, key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            boolean exists = this.items.containsKey(key);
            if (exists) {
                this.deleteFromIndices(this.items.get(key), key);
                this.items.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(List<ApiType> list, String resourceVersion) {
        this.lock.lock();
        try {
            HashMap<String, ApiType> newItems = new HashMap<String, ApiType>();
            for (ApiType ApiType : list) {
                String key = this.keyFunc.apply(ApiType);
                newItems.put(key, ApiType);
            }
            this.items = newItems;
            this.indices = new HashMap<String, Map<String, Set<String>>>();
            for (Map.Entry entry : this.items.entrySet()) {
                this.updateIndices(null, entry.getValue(), (String)entry.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listKeys() {
        this.lock.lock();
        try {
            ArrayList<String> keys = new ArrayList<String>(this.items.size());
            for (Map.Entry<String, ApiType> entry : this.items.entrySet()) {
                keys.add(entry.getKey());
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiType get(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            ApiType ApiType = this.getByKey(key);
            return ApiType;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApiType> list() {
        this.lock.lock();
        try {
            ArrayList<ApiType> itemList = new ArrayList<ApiType>(this.items.size());
            for (Map.Entry<String, ApiType> entry : this.items.entrySet()) {
                itemList.add(entry.getValue());
            }
            ArrayList<ApiType> arrayList = itemList;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ApiType getByKey(String key) {
        this.lock.lock();
        try {
            ApiType ApiType = this.items.get(key);
            return ApiType;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApiType> index(String indexName, Object obj) {
        this.lock.lock();
        try {
            if (!this.indexers.containsKey(indexName)) {
                throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
            }
            Function<ApiType, List<String>> indexFunc = this.indexers.get(indexName);
            List<String> indexKeys = indexFunc.apply(obj);
            Map<String, Set<String>> index = this.indices.get(indexName);
            if (MapUtils.isEmpty(index)) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            HashSet<String> returnKeySet = new HashSet<String>();
            for (String indexKey : indexKeys) {
                Set<String> set = index.get(indexKey);
                if (CollectionUtils.isEmpty(set)) continue;
                returnKeySet.addAll(set);
            }
            ArrayList<ApiType> items = new ArrayList<ApiType>(returnKeySet.size());
            for (String absoluteKey : returnKeySet) {
                items.add(this.items.get(absoluteKey));
            }
            ArrayList<ApiType> arrayList = items;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> indexKeys(String indexName, String indexKey) {
        this.lock.lock();
        try {
            if (!this.indexers.containsKey(indexName)) {
                throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
            }
            Map<String, Set<String>> index = this.indices.get(indexName);
            Set<String> set = index.get(indexKey);
            ArrayList<String> keys = new ArrayList<String>(set.size());
            for (String key : set) {
                keys.add(key);
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApiType> byIndex(String indexName, String indexKey) {
        this.lock.lock();
        try {
            if (!this.indexers.containsKey(indexName)) {
                throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
            }
            Map<String, Set<String>> index = this.indices.get(indexName);
            Set<String> set = index.get(indexKey);
            if (set == null) {
                List<Object> list = Arrays.asList(new Object[0]);
                return list;
            }
            ArrayList<ApiType> items = new ArrayList<ApiType>(set.size());
            for (String key : set) {
                items.add(this.items.get(key));
            }
            ArrayList<ApiType> arrayList = items;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateIndices(ApiType oldObj, ApiType newObj, String key) {
        if (oldObj != null) {
            this.deleteFromIndices(oldObj, key);
        }
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<ApiType, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(newObj);
            if (CollectionUtils.isEmpty(indexValues)) continue;
            Map index = this.indices.computeIfAbsent(indexName, k -> new HashMap());
            for (String indexValue : indexValues) {
                Set indexSet = index.computeIfAbsent(indexValue, k -> new HashSet());
                indexSet.add(key);
            }
        }
    }

    private void deleteFromIndices(ApiType oldObj, String key) {
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : this.indexers.entrySet()) {
            Map<String, Set<String>> index;
            Function<ApiType, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(oldObj);
            if (CollectionUtils.isEmpty(indexValues) || (index = this.indices.get(indexEntry.getKey())) == null) continue;
            for (String indexValue : indexValues) {
                Set<String> indexSet = index.get(indexValue);
                if (indexSet == null) continue;
                indexSet.remove(key);
            }
        }
    }

    public void addIndexFunc(String indexName, Function<ApiType, List<String>> indexFunc) {
        this.indices.put(indexName, new HashMap());
        this.indexers.put(indexName, indexFunc);
    }

    public Function<ApiType, String> getKeyFunc() {
        return this.keyFunc;
    }

    public void setKeyFunc(Function<ApiType, String> keyFunc) {
        this.keyFunc = keyFunc;
    }

    @Deprecated
    public static <ApiType> String deletionHandlingMetaNamespaceKeyFunc(ApiType object) {
        return Caches.deletionHandlingMetaNamespaceKeyFunc(object);
    }

    @Deprecated
    public static String metaNamespaceKeyFunc(Object obj) {
        return Caches.metaNamespaceKeyFunc(obj);
    }

    @Deprecated
    public static List<String> metaNamespaceIndexFunc(Object obj) {
        return Caches.metaNamespaceIndexFunc(obj);
    }
}

