/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.impl.DefaultSharedIndexInformer;
import io.kubernetes.client.util.CallGenerator;
import io.kubernetes.client.util.CallGeneratorParams;
import io.kubernetes.client.util.Watch;
import io.kubernetes.client.util.common.Collections;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SharedInformerFactory {
    protected Map<Type, SharedIndexInformer> informers;
    private Map<Type, Future> startedInformers;
    private ExecutorService informerExecutor;
    private ApiClient apiClient;

    public SharedInformerFactory() {
        this(Configuration.getDefaultApiClient(), Executors.newCachedThreadPool());
    }

    public SharedInformerFactory(ApiClient apiClient) {
        this(apiClient, Executors.newCachedThreadPool());
    }

    public SharedInformerFactory(ExecutorService threadPool) {
        this(Configuration.getDefaultApiClient(), threadPool);
    }

    public SharedInformerFactory(ApiClient client, ExecutorService threadPool) {
        this.apiClient = client;
        this.informerExecutor = threadPool;
        this.informers = new HashMap<Type, SharedIndexInformer>();
        this.startedInformers = new HashMap<Type, Future>();
    }

    public synchronized <ApiType, ApiListType> SharedIndexInformer<ApiType> sharedIndexInformerFor(CallGenerator callGenerator, Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass) {
        return this.sharedIndexInformerFor(callGenerator, apiTypeClass, apiListTypeClass, 0L);
    }

    public synchronized <ApiType, ApiListType> SharedIndexInformer<ApiType> sharedIndexInformerFor(CallGenerator callGenerator, Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, long resyncPeriodInMillis) {
        ListerWatcher<ApiType, ApiListType> listerWatcher = this.listerWatcherFor(callGenerator, apiTypeClass, apiListTypeClass);
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(apiTypeClass, listerWatcher, resyncPeriodInMillis);
        this.informers.putIfAbsent(TypeToken.get(apiTypeClass).getType(), informer);
        return informer;
    }

    private <ApiType, ApiListType> ListerWatcher<ApiType, ApiListType> listerWatcherFor(final CallGenerator callGenerator, final Class<ApiType> apiTypeClass, final Class<ApiListType> apiListTypeClass) {
        this.apiClient.getHttpClient().setReadTimeout(0L, TimeUnit.MILLISECONDS);
        return new ListerWatcher<ApiType, ApiListType>(){

            @Override
            public ApiListType list(CallGeneratorParams params) throws ApiException {
                Call call = callGenerator.generate(params);
                return SharedInformerFactory.this.apiClient.execute(call, (Type)apiListTypeClass).getData();
            }

            @Override
            public Watch<ApiType> watch(CallGeneratorParams params) throws ApiException {
                Call call = callGenerator.generate(params);
                return Watch.createWatch(SharedInformerFactory.this.apiClient, call, TypeToken.getParameterized(Watch.Response.class, (Type[])new Type[]{apiTypeClass}).getType());
            }
        };
    }

    public synchronized <ApiType> SharedIndexInformer<ApiType> getExistingSharedIndexInformer(Class<ApiType> apiTypeClass) {
        return this.informers.get(TypeToken.get(apiTypeClass).getType());
    }

    public synchronized void startAllRegisteredInformers() {
        if (Collections.isEmptyMap(this.informers)) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (!this.startedInformers.containsKey(informerType)) {
                this.startedInformers.put((Type)informerType, this.informerExecutor.submit(informer::run));
            }
        });
    }

    public synchronized void stopAllRegisteredInformers() {
        if (Collections.isEmptyMap(this.informers)) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.containsKey(informerType)) {
                this.startedInformers.remove(informerType);
                informer.stop();
            }
        });
        this.informerExecutor.shutdown();
    }
}

