/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import com.google.common.io.CharStreams;
import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1Status;
import io.kubernetes.client.models.V1StatusCause;
import io.kubernetes.client.models.V1StatusDetails;
import io.kubernetes.client.util.WebSocketStreamHandler;
import io.kubernetes.client.util.WebSockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec {
    private static final Logger log = LoggerFactory.getLogger(Exec.class);
    private ApiClient apiClient;

    public Exec() {
        this(Configuration.getDefaultApiClient());
    }

    public Exec(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private String makePath(String namespace, String name, String[] command, String container, boolean stdin, boolean tty) {
        for (int i = 0; i < command.length; ++i) {
            try {
                command[i] = URLEncoder.encode(command[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("some thing wrong happend: " + ex.getMessage());
            }
        }
        String path = "/api/v1/namespaces/" + namespace + "/pods/" + name + "/exec?stdin=" + stdin + "&stdout=true&stderr=true&tty=" + tty + (container != null ? "&container=" + container : "") + "&command=" + StringUtils.join((Object[])command, (String)"&command=");
        return path;
    }

    public Process exec(String namespace, String name, String[] command, boolean stdin) throws ApiException, IOException {
        return this.exec(namespace, name, command, null, stdin, false);
    }

    public Process exec(V1Pod pod, String[] command, boolean stdin) throws ApiException, IOException {
        return this.exec(pod, command, null, stdin, false);
    }

    public Process exec(String namespace, String name, String[] command, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(namespace, name, command, null, stdin, tty);
    }

    public Process exec(V1Pod pod, String[] command, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(pod, command, null, stdin, tty);
    }

    public Process exec(V1Pod pod, String[] command, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), command, container, stdin, tty);
    }

    public Process exec(String namespace, String name, String[] command, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        String path = this.makePath(namespace, name, command, container, stdin, tty);
        ExecProcess exec = new ExecProcess(this.apiClient);
        WebSocketStreamHandler handler = exec.getHandler();
        WebSockets.stream(path, "GET", this.apiClient, handler);
        return exec;
    }

    static int parseExitCode(ApiClient client, InputStream inputStream) {
        try {
            List causes;
            V1StatusDetails details;
            String body;
            Type returnType = new TypeToken<V1Status>(){}.getType();
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                body = CharStreams.toString((Readable)reader);
            }
            V1Status status = (V1Status)client.getJSON().deserialize(body, returnType);
            if (status == null) {
                return -1;
            }
            if ("Success".equals(status.getStatus())) {
                return 0;
            }
            if ("NonZeroExitCode".equals(status.getReason()) && (details = status.getDetails()) != null && (causes = details.getCauses()) != null) {
                for (V1StatusCause cause : causes) {
                    if (!"ExitCode".equals(cause.getReason())) continue;
                    try {
                        return Integer.parseInt(cause.getMessage());
                    }
                    catch (NumberFormatException nfe) {
                        log.error("Error parsing exit code from status channel response", (Throwable)nfe);
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("Error parsing exit code from status channel response", t);
        }
        return -1;
    }

    protected static class ExecProcess
    extends Process {
        private final WebSocketStreamHandler streamHandler;
        private int statusCode = -1;
        private boolean isAlive = true;
        private final Map<Integer, InputStream> input = new HashMap<Integer, InputStream>();

        public ExecProcess(final ApiClient apiClient) throws IOException {
            this.streamHandler = new WebSocketStreamHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleMessage(int stream, InputStream inStream) throws IOException {
                    if (stream == 3) {
                        int exitCode = Exec.parseExitCode(apiClient, inStream);
                        if (exitCode >= 0) {
                            ExecProcess execProcess = ExecProcess.this;
                            synchronized (execProcess) {
                                ExecProcess.this.statusCode = exitCode;
                                ExecProcess.this.isAlive = false;
                                ExecProcess.this.notifyAll();
                            }
                        }
                    } else {
                        super.handleMessage(stream, inStream);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    ExecProcess execProcess = ExecProcess.this;
                    synchronized (execProcess) {
                        if (ExecProcess.this.isAlive) {
                            ExecProcess.this.isAlive = false;
                            ExecProcess.this.notifyAll();
                        }
                    }
                    super.close();
                }
            };
        }

        protected WebSocketStreamHandler getHandler() {
            return this.streamHandler;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.streamHandler.getOutputStream(0);
        }

        @Override
        public InputStream getInputStream() {
            return this.getInputStream(1);
        }

        @Override
        public InputStream getErrorStream() {
            return this.getInputStream(2);
        }

        private synchronized InputStream getInputStream(int stream) {
            if (!this.input.containsKey(stream)) {
                this.input.put(stream, this.streamHandler.getInputStream(stream));
            }
            return this.input.get(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int waitFor() throws InterruptedException {
            ExecProcess execProcess = this;
            synchronized (execProcess) {
                this.wait();
                return this.statusCode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            ExecProcess execProcess = this;
            synchronized (execProcess) {
                this.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
                return !this.isAlive();
            }
        }

        @Override
        public synchronized int exitValue() {
            if (this.isAlive) {
                throw new IllegalThreadStateException();
            }
            return this.statusCode;
        }

        @Override
        public synchronized boolean isAlive() {
            return this.isAlive;
        }

        @Override
        public void destroy() {
            this.streamHandler.close();
            for (InputStream in : this.input.values()) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.error("Error on close", (Throwable)ex);
                }
            }
        }
    }
}

