/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import com.google.protobuf.Message;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.proto.Meta;
import io.kubernetes.client.proto.Runtime;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ProtoClient {
    private ApiClient apiClient;
    private static final byte[] MAGIC = new byte[]{107, 56, 115, 0};
    private static final String MEDIA_TYPE = "application/vnd.kubernetes.protobuf";

    public ProtoClient() {
        this(Configuration.getDefaultApiClient());
    }

    public ProtoClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public <T extends Message> ObjectOrStatus<T> get(Message.Builder builder, String path) throws ApiException, IOException {
        return this.request(builder, path, "GET", null, null, null);
    }

    public <T extends Message> ObjectOrStatus<T> list(Message.Builder builder, String path) throws ApiException, IOException {
        return this.get(builder, path);
    }

    public <T extends Message> ObjectOrStatus<T> create(T obj, String path, String apiVersion, String kind) throws ApiException, IOException {
        return this.request(obj.newBuilderForType(), path, "POST", obj, apiVersion, kind);
    }

    public <T extends Message> ObjectOrStatus<T> update(T obj, String path, String apiVersion, String kind) throws ApiException, IOException {
        return this.request(obj.newBuilderForType(), path, "PUT", obj, apiVersion, kind);
    }

    public <T extends Message> Meta.Status delete(Message.Builder builder, String path) throws ApiException, IOException {
        return this.request((Message.Builder)builder, (String)path, (String)"DELETE", null, null, null).status;
    }

    public <T extends Message> ObjectOrStatus<T> request(Message.Builder builder, String path, String method, T body, String apiVersion, String kind) throws ApiException, IOException {
        Response resp;
        Runtime.Unknown u;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", MEDIA_TYPE);
        headers.put("Accept", MEDIA_TYPE);
        Request request = this.apiClient.buildRequest(path, method, new ArrayList(), new ArrayList(), null, headers, new HashMap(), new String[0], null);
        if (body != null) {
            byte[] bytes = this.encode(body, apiVersion, kind);
            request = request.newBuilder().post(RequestBody.create((MediaType)MediaType.parse((String)MEDIA_TYPE), (byte[])bytes)).build();
        }
        if ((u = this.parse((resp = this.apiClient.getHttpClient().newCall(request).execute()).body().byteStream())).getTypeMeta().getApiVersion().equals("v1") && u.getTypeMeta().getKind().equals("Status")) {
            Meta.Status status = ((Meta.Status.Builder)Meta.Status.newBuilder().mergeFrom(u.getRaw())).build();
            return new ObjectOrStatus<Object>(null, status);
        }
        return new ObjectOrStatus<Message>(builder.mergeFrom(u.getRaw()).build(), null);
    }

    private byte[] encode(Message msg, String apiVersion, String kind) {
        Runtime.Unknown u = Runtime.Unknown.newBuilder().setTypeMeta(Runtime.TypeMeta.newBuilder().setApiVersion(apiVersion).setKind(kind)).setRaw(msg.toByteString()).build();
        return Bytes.concat((byte[][])new byte[][]{MAGIC, u.toByteArray()});
    }

    private Runtime.Unknown parse(InputStream stream) throws ApiException, IOException {
        byte[] magic = new byte[4];
        ByteStreams.readFully((InputStream)stream, (byte[])magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new ApiException("Unexpected magic number: " + magic);
        }
        return Runtime.Unknown.parseFrom((InputStream)stream);
    }

    public static class ObjectOrStatus<T extends Message> {
        public T object;
        public Meta.Status status;

        public ObjectOrStatus(T obj, Meta.Status status) {
            this.object = obj;
            this.status = status;
        }

        public String toString() {
            if (this.object != null) {
                return this.object.toString();
            }
            return this.status.toString();
        }
    }
}

