/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetUpdateStrategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DaemonSetSpec is the specification of a daemon set.")
public class V1beta2DaemonSetSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    @SerializedName(value="revisionHistoryLimit")
    private Integer revisionHistoryLimit;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    public static final String SERIALIZED_NAME_UPDATE_STRATEGY = "updateStrategy";
    @SerializedName(value="updateStrategy")
    private V1beta2DaemonSetUpdateStrategy updateStrategy;

    public V1beta2DaemonSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1beta2DaemonSetSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.")
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1beta2DaemonSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1beta2DaemonSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1beta2DaemonSetSpec updateStrategy(V1beta2DaemonSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta2DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(V1beta2DaemonSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DaemonSetSpec v1beta2DaemonSetSpec = (V1beta2DaemonSetSpec)o;
        return Objects.equals(this.minReadySeconds, v1beta2DaemonSetSpec.minReadySeconds) && Objects.equals(this.revisionHistoryLimit, v1beta2DaemonSetSpec.revisionHistoryLimit) && Objects.equals(this.selector, v1beta2DaemonSetSpec.selector) && Objects.equals(this.template, v1beta2DaemonSetSpec.template) && Objects.equals(this.updateStrategy, v1beta2DaemonSetSpec.updateStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.revisionHistoryLimit, this.selector, this.template, this.updateStrategy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DaemonSetSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    revisionHistoryLimit: ").append(this.toIndentedString(this.revisionHistoryLimit)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    updateStrategy: ").append(this.toIndentedString(this.updateStrategy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

