/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1beta1Overhead;
import io.kubernetes.client.openapi.models.V1beta1Scheduling;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RuntimeClass defines a class of container runtime supported in the cluster. The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md")
public class V1beta1RuntimeClass {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_HANDLER = "handler";
    @SerializedName(value="handler")
    private String handler;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_OVERHEAD = "overhead";
    @SerializedName(value="overhead")
    private V1beta1Overhead overhead;
    public static final String SERIALIZED_NAME_SCHEDULING = "scheduling";
    @SerializedName(value="scheduling")
    private V1beta1Scheduling scheduling;

    public V1beta1RuntimeClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1RuntimeClass handler(String handler) {
        this.handler = handler;
        return this;
    }

    @ApiModelProperty(required=true, value="Handler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class. The possible values are specific to the node & CRI configuration.  It is assumed that all handlers are available on every node, and handlers of the same name are equivalent on every node. For example, a handler called \"runc\" might specify that the runc OCI runtime (using native Linux containers) will be used to run the containers in a pod. The Handler must conform to the DNS Label (RFC 1123) requirements, and is immutable.")
    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public V1beta1RuntimeClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1RuntimeClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1RuntimeClass overhead(V1beta1Overhead overhead) {
        this.overhead = overhead;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(V1beta1Overhead overhead) {
        this.overhead = overhead;
    }

    public V1beta1RuntimeClass scheduling(V1beta1Scheduling scheduling) {
        this.scheduling = scheduling;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1Scheduling getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(V1beta1Scheduling scheduling) {
        this.scheduling = scheduling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1RuntimeClass v1beta1RuntimeClass = (V1beta1RuntimeClass)o;
        return Objects.equals(this.apiVersion, v1beta1RuntimeClass.apiVersion) && Objects.equals(this.handler, v1beta1RuntimeClass.handler) && Objects.equals(this.kind, v1beta1RuntimeClass.kind) && Objects.equals(this.metadata, v1beta1RuntimeClass.metadata) && Objects.equals(this.overhead, v1beta1RuntimeClass.overhead) && Objects.equals(this.scheduling, v1beta1RuntimeClass.scheduling);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.handler, this.kind, this.metadata, this.overhead, this.scheduling);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1RuntimeClass {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    handler: ").append(this.toIndentedString(this.handler)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    overhead: ").append(this.toIndentedString(this.overhead)).append("\n");
        sb.append("    scheduling: ").append(this.toIndentedString(this.scheduling)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

