/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.kubernetes.client.openapi.models.V1TolerationBuilder;
import io.kubernetes.client.openapi.models.V1TolerationFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1Scheduling;
import io.kubernetes.client.openapi.models.V1alpha1SchedulingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class V1alpha1SchedulingFluentImpl<A extends V1alpha1SchedulingFluent<A>>
extends BaseFluent<A>
implements V1alpha1SchedulingFluent<A> {
    private Map<String, String> nodeSelector;
    private List<V1TolerationBuilder> tolerations;

    public V1alpha1SchedulingFluentImpl() {
    }

    public V1alpha1SchedulingFluentImpl(V1alpha1Scheduling instance) {
        this.withNodeSelector(instance.getNodeSelector());
        this.withTolerations(instance.getTolerations());
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public A addToTolerations(int index, V1Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        V1TolerationBuilder builder = new V1TolerationBuilder(item);
        this._visitables.get("tolerations").add(index >= 0 ? index : this._visitables.get("tolerations").size(), builder);
        this.tolerations.add(index >= 0 ? index : this.tolerations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, V1Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        V1TolerationBuilder builder = new V1TolerationBuilder(item);
        if (index < 0 || index >= this._visitables.get("tolerations").size()) {
            this._visitables.get("tolerations").add(builder);
        } else {
            this._visitables.get("tolerations").set(index, builder);
        }
        if (index < 0 || index >= this.tolerations.size()) {
            this.tolerations.add(builder);
        } else {
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTolerations(V1Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<V1Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(V1Toleration ... items) {
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<V1Toleration> items) {
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTolerations(Predicate<V1TolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<V1TolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            V1TolerationBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Toleration> getTolerations() {
        return V1alpha1SchedulingFluentImpl.build(this.tolerations);
    }

    @Override
    public List<V1Toleration> buildTolerations() {
        return V1alpha1SchedulingFluentImpl.build(this.tolerations);
    }

    @Override
    public V1Toleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    @Override
    public V1Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    @Override
    public V1Toleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    @Override
    public V1Toleration buildMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        for (V1TolerationBuilder item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        for (V1TolerationBuilder item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<V1Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<V1TolerationBuilder>();
            for (V1Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(V1Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (V1Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> addNewToleration() {
        return new TolerationsNestedImpl();
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> addNewTolerationLike(V1Toleration item) {
        return new TolerationsNestedImpl(-1, item);
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> setNewTolerationLike(int index, V1Toleration item) {
        return new TolerationsNestedImpl(index, item);
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public V1alpha1SchedulingFluent.TolerationsNested<A> editMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.apply(this.tolerations.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1SchedulingFluentImpl that = (V1alpha1SchedulingFluentImpl)o;
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        return !(this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null);
    }

    public class TolerationsNestedImpl<N>
    extends V1TolerationFluentImpl<V1alpha1SchedulingFluent.TolerationsNested<N>>
    implements V1alpha1SchedulingFluent.TolerationsNested<N>,
    Nested<N> {
        private final V1TolerationBuilder builder;
        private final int index;

        TolerationsNestedImpl(int index, V1Toleration item) {
            this.index = index;
            this.builder = new V1TolerationBuilder(this, item);
        }

        TolerationsNestedImpl() {
            this.index = -1;
            this.builder = new V1TolerationBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1SchedulingFluentImpl.this.setToTolerations(this.index, this.builder.build());
        }

        @Override
        public N endToleration() {
            return this.and();
        }
    }
}

