/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1alpha1Policy;
import io.kubernetes.client.openapi.models.V1alpha1PolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1alpha1PolicyFluentImpl<A extends V1alpha1PolicyFluent<A>>
extends BaseFluent<A>
implements V1alpha1PolicyFluent<A> {
    private String level;
    private List<String> stages;

    public V1alpha1PolicyFluentImpl() {
    }

    public V1alpha1PolicyFluentImpl(V1alpha1Policy instance) {
        this.withLevel(instance.getLevel());
        this.withStages(instance.getStages());
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public A withLevel(String level) {
        this.level = level;
        return (A)this;
    }

    @Override
    public Boolean hasLevel() {
        return this.level != null;
    }

    @Override
    public A withNewLevel(String arg1) {
        return this.withLevel(new String(arg1));
    }

    @Override
    public A withNewLevel(StringBuilder arg1) {
        return this.withLevel(new String(arg1));
    }

    @Override
    public A withNewLevel(StringBuffer arg1) {
        return this.withLevel(new String(arg1));
    }

    @Override
    public A addToStages(int index, String item) {
        if (this.stages == null) {
            this.stages = new ArrayList<String>();
        }
        this.stages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToStages(int index, String item) {
        if (this.stages == null) {
            this.stages = new ArrayList<String>();
        }
        this.stages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToStages(String ... items) {
        if (this.stages == null) {
            this.stages = new ArrayList<String>();
        }
        for (String item : items) {
            this.stages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToStages(Collection<String> items) {
        if (this.stages == null) {
            this.stages = new ArrayList<String>();
        }
        for (String item : items) {
            this.stages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromStages(String ... items) {
        for (String item : items) {
            if (this.stages == null) continue;
            this.stages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStages(Collection<String> items) {
        for (String item : items) {
            if (this.stages == null) continue;
            this.stages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getStages() {
        return this.stages;
    }

    @Override
    public String getStage(int index) {
        return this.stages.get(index);
    }

    @Override
    public String getFirstStage() {
        return this.stages.get(0);
    }

    @Override
    public String getLastStage() {
        return this.stages.get(this.stages.size() - 1);
    }

    @Override
    public String getMatchingStage(Predicate<String> predicate) {
        for (String item : this.stages) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStage(Predicate<String> predicate) {
        for (String item : this.stages) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStages(List<String> stages) {
        if (this.stages != null) {
            this._visitables.get("stages").removeAll(this.stages);
        }
        if (stages != null) {
            this.stages = new ArrayList<String>();
            for (String item : stages) {
                this.addToStages(item);
            }
        } else {
            this.stages = null;
        }
        return (A)this;
    }

    @Override
    public A withStages(String ... stages) {
        if (this.stages != null) {
            this.stages.clear();
        }
        if (stages != null) {
            for (String item : stages) {
                this.addToStages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStages() {
        return this.stages != null && !this.stages.isEmpty();
    }

    @Override
    public A addNewStage(String arg1) {
        return this.addToStages(new String(arg1));
    }

    @Override
    public A addNewStage(StringBuilder arg1) {
        return this.addToStages(new String(arg1));
    }

    @Override
    public A addNewStage(StringBuffer arg1) {
        return this.addToStages(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PolicyFluentImpl that = (V1alpha1PolicyFluentImpl)o;
        if (this.level != null ? !this.level.equals(that.level) : that.level != null) {
            return false;
        }
        return !(this.stages != null ? !this.stages.equals(that.stages) : that.stages != null);
    }
}

