/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.ApiextensionsV1beta1WebhookClientConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="CustomResourceConversion describes how to convert different versions of a CR.")
public class V1beta1CustomResourceConversion {
    @SerializedName(value="strategy")
    private String strategy = null;
    @SerializedName(value="webhookClientConfig")
    private ApiextensionsV1beta1WebhookClientConfig webhookClientConfig = null;

    public V1beta1CustomResourceConversion strategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    @ApiModelProperty(required=true, value="`strategy` specifies the conversion strategy. Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the CR. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information is needed for this option.")
    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public V1beta1CustomResourceConversion webhookClientConfig(ApiextensionsV1beta1WebhookClientConfig webhookClientConfig) {
        this.webhookClientConfig = webhookClientConfig;
        return this;
    }

    @ApiModelProperty(value="`webhookClientConfig` is the instructions for how to call the webhook if strategy is `Webhook`. This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.")
    public ApiextensionsV1beta1WebhookClientConfig getWebhookClientConfig() {
        return this.webhookClientConfig;
    }

    public void setWebhookClientConfig(ApiextensionsV1beta1WebhookClientConfig webhookClientConfig) {
        this.webhookClientConfig = webhookClientConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CustomResourceConversion v1beta1CustomResourceConversion = (V1beta1CustomResourceConversion)o;
        return Objects.equals(this.strategy, v1beta1CustomResourceConversion.strategy) && Objects.equals(this.webhookClientConfig, v1beta1CustomResourceConversion.webhookClientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.strategy, this.webhookClientConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CustomResourceConversion {\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("    webhookClientConfig: ").append(this.toIndentedString(this.webhookClientConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

