/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1ResourceRequirements;
import io.kubernetes.client.models.V1TypedLocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes")
public class V1PersistentVolumeClaimSpec {
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    @SerializedName(value="dataSource")
    private V1TypedLocalObjectReference dataSource = null;
    @SerializedName(value="resources")
    private V1ResourceRequirements resources = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="storageClassName")
    private String storageClassName = null;
    @SerializedName(value="volumeMode")
    private String volumeMode = null;
    @SerializedName(value="volumeName")
    private String volumeName = null;

    public V1PersistentVolumeClaimSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @ApiModelProperty(value="AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimSpec dataSource(V1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @ApiModelProperty(value="This field requires the VolumeSnapshotDataSource alpha feature gate to be enabled and currently VolumeSnapshot is the only supported data source. If the provisioner can support VolumeSnapshot data source, it will create a new volume and data will be restored to the volume at the same time. If the provisioner does not support VolumeSnapshot data source, volume will not be created and the failure will be reported as an event. In the future, we plan to support more data source types and the behavior of the provisioner may change.")
    public V1TypedLocalObjectReference getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(V1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
    }

    public V1PersistentVolumeClaimSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1PersistentVolumeClaimSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="A label query over volumes to consider for binding.")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1PersistentVolumeClaimSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @ApiModelProperty(value="Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1")
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public V1PersistentVolumeClaimSpec volumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    @ApiModelProperty(value="volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. This is an alpha feature and may change in the future.")
    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public V1PersistentVolumeClaimSpec volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @ApiModelProperty(value="VolumeName is the binding reference to the PersistentVolume backing this claim.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimSpec v1PersistentVolumeClaimSpec = (V1PersistentVolumeClaimSpec)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimSpec.accessModes) && Objects.equals(this.dataSource, v1PersistentVolumeClaimSpec.dataSource) && Objects.equals(this.resources, v1PersistentVolumeClaimSpec.resources) && Objects.equals(this.selector, v1PersistentVolumeClaimSpec.selector) && Objects.equals(this.storageClassName, v1PersistentVolumeClaimSpec.storageClassName) && Objects.equals(this.volumeMode, v1PersistentVolumeClaimSpec.volumeMode) && Objects.equals(this.volumeName, v1PersistentVolumeClaimSpec.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.resources, this.selector, this.storageClassName, this.volumeMode, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    volumeMode: ").append(this.toIndentedString(this.volumeMode)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

