/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ComponentCondition;
import io.kubernetes.client.models.V1ComponentConditionBuilder;
import io.kubernetes.client.models.V1ComponentConditionFluentImpl;
import io.kubernetes.client.models.V1ComponentStatus;
import io.kubernetes.client.models.V1ComponentStatusFluent;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1ComponentStatusFluentImpl<A extends V1ComponentStatusFluent<A>>
extends BaseFluent<A>
implements V1ComponentStatusFluent<A> {
    private String apiVersion;
    private List<V1ComponentConditionBuilder> conditions;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1ComponentStatusFluentImpl() {
    }

    public V1ComponentStatusFluentImpl(V1ComponentStatus instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToConditions(int index, V1ComponentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ComponentConditionBuilder>();
        }
        V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1ComponentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ComponentConditionBuilder>();
        }
        V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1ComponentCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ComponentConditionBuilder>();
        }
        for (V1ComponentCondition item : items) {
            V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1ComponentCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ComponentConditionBuilder>();
        }
        for (V1ComponentCondition item : items) {
            V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1ComponentCondition ... items) {
        for (V1ComponentCondition item : items) {
            V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1ComponentCondition> items) {
        for (V1ComponentCondition item : items) {
            V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ComponentCondition> getConditions() {
        return V1ComponentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1ComponentCondition> buildConditions() {
        return V1ComponentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1ComponentCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1ComponentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1ComponentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1ComponentCondition buildMatchingCondition(Predicate<V1ComponentConditionBuilder> predicate) {
        for (V1ComponentConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<V1ComponentCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1ComponentConditionBuilder>();
            for (V1ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1ComponentCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(V1ComponentCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1ComponentCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1ComponentStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1ComponentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ComponentStatusFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ComponentStatusFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ComponentStatusFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ComponentStatusFluentImpl that = (V1ComponentStatusFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ComponentStatusFluent.MetadataNested<N>>
    implements V1ComponentStatusFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ComponentStatusFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends V1ComponentConditionFluentImpl<V1ComponentStatusFluent.ConditionsNested<N>>
    implements V1ComponentStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1ComponentConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1ComponentCondition item) {
            this.index = index;
            this.builder = new V1ComponentConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1ComponentConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ComponentStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

