/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1EventSource;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectReference;
import io.kubernetes.client.models.V1beta1EventSeries;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.")
public class V1beta1Event {
    @SerializedName(value="action")
    private String action = null;
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="deprecatedCount")
    private Integer deprecatedCount = null;
    @SerializedName(value="deprecatedFirstTimestamp")
    private DateTime deprecatedFirstTimestamp = null;
    @SerializedName(value="deprecatedLastTimestamp")
    private DateTime deprecatedLastTimestamp = null;
    @SerializedName(value="deprecatedSource")
    private V1EventSource deprecatedSource = null;
    @SerializedName(value="eventTime")
    private DateTime eventTime = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="note")
    private String note = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="regarding")
    private V1ObjectReference regarding = null;
    @SerializedName(value="related")
    private V1ObjectReference related = null;
    @SerializedName(value="reportingController")
    private String reportingController = null;
    @SerializedName(value="reportingInstance")
    private String reportingInstance = null;
    @SerializedName(value="series")
    private V1beta1EventSeries series = null;
    @SerializedName(value="type")
    private String type = null;

    public V1beta1Event action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="What action was taken/failed regarding to the regarding object.")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public V1beta1Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1Event deprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
        return this;
    }

    @ApiModelProperty(value="Deprecated field assuring backward compatibility with core.v1 Event type")
    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    public void setDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
    }

    public V1beta1Event deprecatedFirstTimestamp(DateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        return this;
    }

    @ApiModelProperty(value="Deprecated field assuring backward compatibility with core.v1 Event type")
    public DateTime getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    public void setDeprecatedFirstTimestamp(DateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
    }

    public V1beta1Event deprecatedLastTimestamp(DateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        return this;
    }

    @ApiModelProperty(value="Deprecated field assuring backward compatibility with core.v1 Event type")
    public DateTime getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    public void setDeprecatedLastTimestamp(DateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
    }

    public V1beta1Event deprecatedSource(V1EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
        return this;
    }

    @ApiModelProperty(value="Deprecated field assuring backward compatibility with core.v1 Event type")
    public V1EventSource getDeprecatedSource() {
        return this.deprecatedSource;
    }

    public void setDeprecatedSource(V1EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
    }

    public V1beta1Event eventTime(DateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. Time when this Event was first observed.")
    public DateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(DateTime eventTime) {
        this.eventTime = eventTime;
    }

    public V1beta1Event kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1Event metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1Event note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public V1beta1Event reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Why the action was taken.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1beta1Event regarding(V1ObjectReference regarding) {
        this.regarding = regarding;
        return this;
    }

    @ApiModelProperty(value="The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.")
    public V1ObjectReference getRegarding() {
        return this.regarding;
    }

    public void setRegarding(V1ObjectReference regarding) {
        this.regarding = regarding;
    }

    public V1beta1Event related(V1ObjectReference related) {
        this.related = related;
        return this;
    }

    @ApiModelProperty(value="Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.")
    public V1ObjectReference getRelated() {
        return this.related;
    }

    public void setRelated(V1ObjectReference related) {
        this.related = related;
    }

    public V1beta1Event reportingController(String reportingController) {
        this.reportingController = reportingController;
        return this;
    }

    @ApiModelProperty(value="Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.")
    public String getReportingController() {
        return this.reportingController;
    }

    public void setReportingController(String reportingController) {
        this.reportingController = reportingController;
    }

    public V1beta1Event reportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return this;
    }

    @ApiModelProperty(value="ID of the controller instance, e.g. `kubelet-xyzf`.")
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public void setReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
    }

    public V1beta1Event series(V1beta1EventSeries series) {
        this.series = series;
        return this;
    }

    @ApiModelProperty(value="Data about the Event series this event represents or nil if it's a singleton Event.")
    public V1beta1EventSeries getSeries() {
        return this.series;
    }

    public void setSeries(V1beta1EventSeries series) {
        this.series = series;
    }

    public V1beta1Event type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of this event (Normal, Warning), new types could be added in the future.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Event v1beta1Event = (V1beta1Event)o;
        return Objects.equals(this.action, v1beta1Event.action) && Objects.equals(this.apiVersion, v1beta1Event.apiVersion) && Objects.equals(this.deprecatedCount, v1beta1Event.deprecatedCount) && Objects.equals(this.deprecatedFirstTimestamp, v1beta1Event.deprecatedFirstTimestamp) && Objects.equals(this.deprecatedLastTimestamp, v1beta1Event.deprecatedLastTimestamp) && Objects.equals(this.deprecatedSource, v1beta1Event.deprecatedSource) && Objects.equals(this.eventTime, v1beta1Event.eventTime) && Objects.equals(this.kind, v1beta1Event.kind) && Objects.equals(this.metadata, v1beta1Event.metadata) && Objects.equals(this.note, v1beta1Event.note) && Objects.equals(this.reason, v1beta1Event.reason) && Objects.equals(this.regarding, v1beta1Event.regarding) && Objects.equals(this.related, v1beta1Event.related) && Objects.equals(this.reportingController, v1beta1Event.reportingController) && Objects.equals(this.reportingInstance, v1beta1Event.reportingInstance) && Objects.equals(this.series, v1beta1Event.series) && Objects.equals(this.type, v1beta1Event.type);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.deprecatedCount, this.deprecatedFirstTimestamp, this.deprecatedLastTimestamp, this.deprecatedSource, this.eventTime, this.kind, this.metadata, this.note, this.reason, this.regarding, this.related, this.reportingController, this.reportingInstance, this.series, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Event {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    deprecatedCount: ").append(this.toIndentedString(this.deprecatedCount)).append("\n");
        sb.append("    deprecatedFirstTimestamp: ").append(this.toIndentedString(this.deprecatedFirstTimestamp)).append("\n");
        sb.append("    deprecatedLastTimestamp: ").append(this.toIndentedString(this.deprecatedLastTimestamp)).append("\n");
        sb.append("    deprecatedSource: ").append(this.toIndentedString(this.deprecatedSource)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    regarding: ").append(this.toIndentedString(this.regarding)).append("\n");
        sb.append("    related: ").append(this.toIndentedString(this.related)).append("\n");
        sb.append("    reportingController: ").append(this.toIndentedString(this.reportingController)).append("\n");
        sb.append("    reportingInstance: ").append(this.toIndentedString(this.reportingInstance)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

