/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1KeyToPath;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Adapts a ConfigMap into a projected volume.  The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.")
public class V1ConfigMapProjection {
    @SerializedName(value="items")
    private List<V1KeyToPath> items = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="optional")
    private Boolean optional = null;

    public V1ConfigMapProjection items(List<V1KeyToPath> items) {
        this.items = items;
        return this;
    }

    public V1ConfigMapProjection addItemsItem(V1KeyToPath itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPath>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    public List<V1KeyToPath> getItems() {
        return this.items;
    }

    public void setItems(List<V1KeyToPath> items) {
        this.items = items;
    }

    public V1ConfigMapProjection name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ConfigMapProjection optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @ApiModelProperty(value="Specify whether the ConfigMap or it's keys must be defined")
    public Boolean isOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMapProjection v1ConfigMapProjection = (V1ConfigMapProjection)o;
        return Objects.equals(this.items, v1ConfigMapProjection.items) && Objects.equals(this.name, v1ConfigMapProjection.name) && Objects.equals(this.optional, v1ConfigMapProjection.optional);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.name, this.optional);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ConfigMapProjection {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

