/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined. Deprecated: use AllowedHostPath from policy API Group instead.")
public class ExtensionsV1beta1AllowedHostPath {
    @SerializedName(value="pathPrefix")
    private String pathPrefix = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;

    public ExtensionsV1beta1AllowedHostPath pathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    @ApiModelProperty(value="pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.  Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`")
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public ExtensionsV1beta1AllowedHostPath readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsV1beta1AllowedHostPath extensionsV1beta1AllowedHostPath = (ExtensionsV1beta1AllowedHostPath)o;
        return Objects.equals(this.pathPrefix, extensionsV1beta1AllowedHostPath.pathPrefix) && Objects.equals(this.readOnly, extensionsV1beta1AllowedHostPath.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.pathPrefix, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtensionsV1beta1AllowedHostPath {\n");
        sb.append("    pathPrefix: ").append(this.toIndentedString(this.pathPrefix)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

