/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ResourceRule;
import io.kubernetes.client.models.V1ResourceRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1ResourceRuleFluentImpl<A extends V1ResourceRuleFluent<A>>
extends BaseFluent<A>
implements V1ResourceRuleFluent<A> {
    private List<String> apiGroups;
    private List<String> resourceNames;
    private List<String> resources;
    private List<String> verbs;

    public V1ResourceRuleFluentImpl() {
    }

    public V1ResourceRuleFluentImpl(V1ResourceRule instance) {
        this.withApiGroups(instance.getApiGroups());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
    }

    @Override
    public A addToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiGroups(int index, String item) {
        this.apiGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiGroups(String ... items) {
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiGroups(Collection<String> items) {
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiGroups(String ... items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    @Override
    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    @Override
    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    @Override
    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    @Override
    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withApiGroups(List<String> apiGroups) {
        if (this.apiGroups != null) {
            this._visitables.removeAll(this.apiGroups);
        }
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withApiGroups(String ... apiGroups) {
        this.apiGroups.clear();
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    @Override
    public A addToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResourceNames(int index, String item) {
        this.resourceNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResourceNames(String ... items) {
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceNames(Collection<String> items) {
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceNames(String ... items) {
        for (String item : items) {
            if (this.resourceNames == null) continue;
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceNames(Collection<String> items) {
        for (String item : items) {
            if (this.resourceNames == null) continue;
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    @Override
    public String getResourceName(int index) {
        return this.resourceNames.get(index);
    }

    @Override
    public String getFirstResourceName() {
        return this.resourceNames.get(0);
    }

    @Override
    public String getLastResourceName() {
        return this.resourceNames.get(this.resourceNames.size() - 1);
    }

    @Override
    public String getMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withResourceNames(List<String> resourceNames) {
        if (this.resourceNames != null) {
            this._visitables.removeAll(this.resourceNames);
        }
        if (resourceNames != null) {
            this.resourceNames = new ArrayList<String>();
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        } else {
            this.resourceNames = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceNames(String ... resourceNames) {
        this.resourceNames.clear();
        if (resourceNames != null) {
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceNames() {
        return this.resourceNames != null && !this.resourceNames.isEmpty();
    }

    @Override
    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResources(int index, String item) {
        this.resources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResources(String ... items) {
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<String> items) {
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(String ... items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResources() {
        return this.resources;
    }

    @Override
    public String getResource(int index) {
        return this.resources.get(index);
    }

    @Override
    public String getFirstResource() {
        return this.resources.get(0);
    }

    @Override
    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    @Override
    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withResources(List<String> resources) {
        if (this.resources != null) {
            this._visitables.removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(String ... resources) {
        this.resources.clear();
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(int index, String item) {
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (this.verbs != null) {
            this._visitables.removeAll(this.verbs);
        }
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        this.verbs.clear();
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ResourceRuleFluentImpl that = (V1ResourceRuleFluentImpl)o;
        if (this.apiGroups != null ? !this.apiGroups.equals(that.apiGroups) : that.apiGroups != null) {
            return false;
        }
        if (this.resourceNames != null ? !this.resourceNames.equals(that.resourceNames) : that.resourceNames != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null);
    }
}

