/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). Exactly one \"target\" type should be set.")
public class V2beta1ExternalMetricSource {
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="metricSelector")
    private V1LabelSelector metricSelector = null;
    @SerializedName(value="targetAverageValue")
    private Quantity targetAverageValue = null;
    @SerializedName(value="targetValue")
    private Quantity targetValue = null;

    public V2beta1ExternalMetricSource metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question.")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1ExternalMetricSource metricSelector(V1LabelSelector metricSelector) {
        this.metricSelector = metricSelector;
        return this;
    }

    @ApiModelProperty(value="metricSelector is used to identify a specific time series within a given metric.")
    public V1LabelSelector getMetricSelector() {
        return this.metricSelector;
    }

    public void setMetricSelector(V1LabelSelector metricSelector) {
        this.metricSelector = metricSelector;
    }

    public V2beta1ExternalMetricSource targetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return this;
    }

    @ApiModelProperty(value="targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.")
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public void setTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
    }

    public V2beta1ExternalMetricSource targetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return this;
    }

    @ApiModelProperty(value="targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.")
    public Quantity getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ExternalMetricSource v2beta1ExternalMetricSource = (V2beta1ExternalMetricSource)o;
        return Objects.equals(this.metricName, v2beta1ExternalMetricSource.metricName) && Objects.equals(this.metricSelector, v2beta1ExternalMetricSource.metricSelector) && Objects.equals(this.targetAverageValue, v2beta1ExternalMetricSource.targetAverageValue) && Objects.equals(this.targetValue, v2beta1ExternalMetricSource.targetValue);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.metricSelector, this.targetAverageValue, this.targetValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1ExternalMetricSource {\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    metricSelector: ").append(this.toIndentedString(this.metricSelector)).append("\n");
        sb.append("    targetAverageValue: ").append(this.toIndentedString(this.targetAverageValue)).append("\n");
        sb.append("    targetValue: ").append(this.toIndentedString(this.targetValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

