/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1alpha1Initializer;
import io.kubernetes.client.models.V1alpha1InitializerBuilder;
import io.kubernetes.client.models.V1alpha1InitializerConfiguration;
import io.kubernetes.client.models.V1alpha1InitializerConfigurationFluent;
import io.kubernetes.client.models.V1alpha1InitializerFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1alpha1InitializerConfigurationFluentImpl<A extends V1alpha1InitializerConfigurationFluent<A>>
extends BaseFluent<A>
implements V1alpha1InitializerConfigurationFluent<A> {
    private String apiVersion;
    private List<V1alpha1InitializerBuilder> initializers;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1alpha1InitializerConfigurationFluentImpl() {
    }

    public V1alpha1InitializerConfigurationFluentImpl(V1alpha1InitializerConfiguration instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withInitializers(instance.getInitializers());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToInitializers(int index, V1alpha1Initializer item) {
        if (this.initializers == null) {
            this.initializers = new ArrayList<V1alpha1InitializerBuilder>();
        }
        V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.initializers.add(index >= 0 ? index : this.initializers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitializers(int index, V1alpha1Initializer item) {
        if (this.initializers == null) {
            this.initializers = new ArrayList<V1alpha1InitializerBuilder>();
        }
        V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.initializers.size()) {
            this.initializers.add(builder);
        } else {
            this.initializers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitializers(V1alpha1Initializer ... items) {
        if (this.initializers == null) {
            this.initializers = new ArrayList<V1alpha1InitializerBuilder>();
        }
        for (V1alpha1Initializer item : items) {
            V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
            this._visitables.add(builder);
            this.initializers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitializers(Collection<V1alpha1Initializer> items) {
        if (this.initializers == null) {
            this.initializers = new ArrayList<V1alpha1InitializerBuilder>();
        }
        for (V1alpha1Initializer item : items) {
            V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
            this._visitables.add(builder);
            this.initializers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitializers(V1alpha1Initializer ... items) {
        for (V1alpha1Initializer item : items) {
            V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
            this._visitables.remove(builder);
            if (this.initializers == null) continue;
            this.initializers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitializers(Collection<V1alpha1Initializer> items) {
        for (V1alpha1Initializer item : items) {
            V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
            this._visitables.remove(builder);
            if (this.initializers == null) continue;
            this.initializers.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha1Initializer> getInitializers() {
        return V1alpha1InitializerConfigurationFluentImpl.build(this.initializers);
    }

    @Override
    public List<V1alpha1Initializer> buildInitializers() {
        return V1alpha1InitializerConfigurationFluentImpl.build(this.initializers);
    }

    @Override
    public V1alpha1Initializer buildInitializer(int index) {
        return this.initializers.get(index).build();
    }

    @Override
    public V1alpha1Initializer buildFirstInitializer() {
        return this.initializers.get(0).build();
    }

    @Override
    public V1alpha1Initializer buildLastInitializer() {
        return this.initializers.get(this.initializers.size() - 1).build();
    }

    @Override
    public V1alpha1Initializer buildMatchingInitializer(Predicate<V1alpha1InitializerBuilder> predicate) {
        for (V1alpha1InitializerBuilder item : this.initializers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withInitializers(List<V1alpha1Initializer> initializers) {
        if (this.initializers != null) {
            this._visitables.removeAll(this.initializers);
        }
        if (initializers != null) {
            this.initializers = new ArrayList<V1alpha1InitializerBuilder>();
            for (V1alpha1Initializer item : initializers) {
                this.addToInitializers(item);
            }
        } else {
            this.initializers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitializers(V1alpha1Initializer ... initializers) {
        this.initializers.clear();
        if (initializers != null) {
            for (V1alpha1Initializer item : initializers) {
                this.addToInitializers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitializers() {
        return this.initializers != null && !this.initializers.isEmpty();
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> addNewInitializer() {
        return new InitializersNestedImpl();
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> addNewInitializerLike(V1alpha1Initializer item) {
        return new InitializersNestedImpl(-1, item);
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> setNewInitializerLike(int index, V1alpha1Initializer item) {
        return new InitializersNestedImpl(index, item);
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editInitializer(int index) {
        if (this.initializers.size() <= index) {
            throw new RuntimeException("Can't edit initializers. Index exceeds size.");
        }
        return this.setNewInitializerLike(index, this.buildInitializer(index));
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editFirstInitializer() {
        if (this.initializers.size() == 0) {
            throw new RuntimeException("Can't edit first initializers. The list is empty.");
        }
        return this.setNewInitializerLike(0, this.buildInitializer(0));
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editLastInitializer() {
        int index = this.initializers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initializers. The list is empty.");
        }
        return this.setNewInitializerLike(index, this.buildInitializer(index));
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editMatchingInitializer(Predicate<V1alpha1InitializerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initializers.size(); ++i) {
            if (!predicate.apply(this.initializers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initializers. No match found.");
        }
        return this.setNewInitializerLike(index, this.buildInitializer(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1InitializerConfigurationFluentImpl that = (V1alpha1InitializerConfigurationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.initializers != null ? !this.initializers.equals(that.initializers) : that.initializers != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1alpha1InitializerConfigurationFluent.MetadataNested<N>>
    implements V1alpha1InitializerConfigurationFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1InitializerConfigurationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class InitializersNestedImpl<N>
    extends V1alpha1InitializerFluentImpl<V1alpha1InitializerConfigurationFluent.InitializersNested<N>>
    implements V1alpha1InitializerConfigurationFluent.InitializersNested<N>,
    Nested<N> {
        private final V1alpha1InitializerBuilder builder;
        private final int index;

        InitializersNestedImpl(int index, V1alpha1Initializer item) {
            this.index = index;
            this.builder = new V1alpha1InitializerBuilder(this, item);
        }

        InitializersNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1InitializerBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1InitializerConfigurationFluentImpl.this.setToInitializers(this.index, this.builder.build());
        }

        @Override
        public N endInitializer() {
            return this.and();
        }
    }
}

