/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1AttachedVolume;
import io.kubernetes.client.models.V1AttachedVolumeBuilder;
import io.kubernetes.client.models.V1AttachedVolumeFluentImpl;
import io.kubernetes.client.models.V1ContainerImage;
import io.kubernetes.client.models.V1ContainerImageBuilder;
import io.kubernetes.client.models.V1ContainerImageFluentImpl;
import io.kubernetes.client.models.V1NodeAddress;
import io.kubernetes.client.models.V1NodeAddressBuilder;
import io.kubernetes.client.models.V1NodeAddressFluentImpl;
import io.kubernetes.client.models.V1NodeCondition;
import io.kubernetes.client.models.V1NodeConditionBuilder;
import io.kubernetes.client.models.V1NodeConditionFluentImpl;
import io.kubernetes.client.models.V1NodeConfigStatus;
import io.kubernetes.client.models.V1NodeConfigStatusBuilder;
import io.kubernetes.client.models.V1NodeConfigStatusFluentImpl;
import io.kubernetes.client.models.V1NodeDaemonEndpoints;
import io.kubernetes.client.models.V1NodeDaemonEndpointsBuilder;
import io.kubernetes.client.models.V1NodeDaemonEndpointsFluentImpl;
import io.kubernetes.client.models.V1NodeStatus;
import io.kubernetes.client.models.V1NodeStatusFluent;
import io.kubernetes.client.models.V1NodeSystemInfo;
import io.kubernetes.client.models.V1NodeSystemInfoBuilder;
import io.kubernetes.client.models.V1NodeSystemInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class V1NodeStatusFluentImpl<A extends V1NodeStatusFluent<A>>
extends BaseFluent<A>
implements V1NodeStatusFluent<A> {
    private List<V1NodeAddressBuilder> addresses;
    private Map<String, Quantity> allocatable;
    private Map<String, Quantity> capacity;
    private List<V1NodeConditionBuilder> conditions;
    private V1NodeConfigStatusBuilder config;
    private V1NodeDaemonEndpointsBuilder daemonEndpoints;
    private List<V1ContainerImageBuilder> images;
    private V1NodeSystemInfoBuilder nodeInfo;
    private String phase;
    private List<V1AttachedVolumeBuilder> volumesAttached;
    private List<String> volumesInUse;

    public V1NodeStatusFluentImpl() {
    }

    public V1NodeStatusFluentImpl(V1NodeStatus instance) {
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withConfig(instance.getConfig());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
        this.withVolumesAttached(instance.getVolumesAttached());
        this.withVolumesInUse(instance.getVolumesInUse());
    }

    @Override
    public A addToAddresses(int index, V1NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddressBuilder>();
        }
        V1NodeAddressBuilder builder = new V1NodeAddressBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.addresses.add(index >= 0 ? index : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, V1NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddressBuilder>();
        }
        V1NodeAddressBuilder builder = new V1NodeAddressBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(V1NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddressBuilder>();
        }
        for (V1NodeAddress item : items) {
            V1NodeAddressBuilder builder = new V1NodeAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<V1NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddressBuilder>();
        }
        for (V1NodeAddress item : items) {
            V1NodeAddressBuilder builder = new V1NodeAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(V1NodeAddress ... items) {
        for (V1NodeAddress item : items) {
            V1NodeAddressBuilder builder = new V1NodeAddressBuilder(item);
            this._visitables.remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<V1NodeAddress> items) {
        for (V1NodeAddress item : items) {
            V1NodeAddressBuilder builder = new V1NodeAddressBuilder(item);
            this._visitables.remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1NodeAddress> getAddresses() {
        return V1NodeStatusFluentImpl.build(this.addresses);
    }

    @Override
    public List<V1NodeAddress> buildAddresses() {
        return V1NodeStatusFluentImpl.build(this.addresses);
    }

    @Override
    public V1NodeAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public V1NodeAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public V1NodeAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public V1NodeAddress buildMatchingAddress(Predicate<V1NodeAddressBuilder> predicate) {
        for (V1NodeAddressBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withAddresses(List<V1NodeAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<V1NodeAddressBuilder>();
            for (V1NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(V1NodeAddress ... addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (V1NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> addNewAddressLike(V1NodeAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> setNewAddressLike(int index, V1NodeAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public V1NodeStatusFluent.AddressesNested<A> editMatchingAddress(Predicate<V1NodeAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.apply(this.addresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToAllocatable(String key, Quantity value) {
        if (this.allocatable == null && key != null && value != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null && map != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(String key) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (key != null && this.allocatable != null) {
            this.allocatable.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatable == null) continue;
                this.allocatable.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    @Override
    public A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable == null ? null : new LinkedHashMap<String, Quantity>(allocatable);
        return (A)this;
    }

    @Override
    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public A addToConditions(int index, V1NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeConditionBuilder>();
        }
        V1NodeConditionBuilder builder = new V1NodeConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeConditionBuilder>();
        }
        V1NodeConditionBuilder builder = new V1NodeConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1NodeCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeConditionBuilder>();
        }
        for (V1NodeCondition item : items) {
            V1NodeConditionBuilder builder = new V1NodeConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1NodeCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeConditionBuilder>();
        }
        for (V1NodeCondition item : items) {
            V1NodeConditionBuilder builder = new V1NodeConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1NodeCondition ... items) {
        for (V1NodeCondition item : items) {
            V1NodeConditionBuilder builder = new V1NodeConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1NodeCondition> items) {
        for (V1NodeCondition item : items) {
            V1NodeConditionBuilder builder = new V1NodeConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1NodeCondition> getConditions() {
        return V1NodeStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1NodeCondition> buildConditions() {
        return V1NodeStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1NodeCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1NodeCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1NodeCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1NodeCondition buildMatchingCondition(Predicate<V1NodeConditionBuilder> predicate) {
        for (V1NodeConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<V1NodeCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1NodeConditionBuilder>();
            for (V1NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1NodeCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (V1NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> addNewConditionLike(V1NodeCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1NodeCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1NodeStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1NodeConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public V1NodeConfigStatus getConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public V1NodeConfigStatus buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public A withConfig(V1NodeConfigStatus config) {
        this._visitables.remove(this.config);
        if (config != null) {
            this.config = new V1NodeConfigStatusBuilder(config);
            this._visitables.add(this.config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public V1NodeStatusFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.ConfigNested<A> withNewConfigLike(V1NodeConfigStatus item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public V1NodeStatusFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public V1NodeStatusFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new V1NodeConfigStatusBuilder().build());
    }

    @Override
    public V1NodeStatusFluent.ConfigNested<A> editOrNewConfigLike(V1NodeConfigStatus item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    @Deprecated
    public V1NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
    }

    @Override
    public V1NodeDaemonEndpoints buildDaemonEndpoints() {
        return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
    }

    @Override
    public A withDaemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this._visitables.remove(this.daemonEndpoints);
        if (daemonEndpoints != null) {
            this.daemonEndpoints = new V1NodeDaemonEndpointsBuilder(daemonEndpoints);
            this._visitables.add(this.daemonEndpoints);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDaemonEndpoints() {
        return this.daemonEndpoints != null;
    }

    @Override
    public V1NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints() {
        return new DaemonEndpointsNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(V1NodeDaemonEndpoints item) {
        return new DaemonEndpointsNestedImpl(item);
    }

    @Override
    public V1NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints());
    }

    @Override
    public V1NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints() != null ? this.getDaemonEndpoints() : new V1NodeDaemonEndpointsBuilder().build());
    }

    @Override
    public V1NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(V1NodeDaemonEndpoints item) {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints() != null ? this.getDaemonEndpoints() : item);
    }

    @Override
    public A addToImages(int index, V1ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImageBuilder>();
        }
        V1ContainerImageBuilder builder = new V1ContainerImageBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, V1ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImageBuilder>();
        }
        V1ContainerImageBuilder builder = new V1ContainerImageBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(V1ContainerImage ... items) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImageBuilder>();
        }
        for (V1ContainerImage item : items) {
            V1ContainerImageBuilder builder = new V1ContainerImageBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<V1ContainerImage> items) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImageBuilder>();
        }
        for (V1ContainerImage item : items) {
            V1ContainerImageBuilder builder = new V1ContainerImageBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(V1ContainerImage ... items) {
        for (V1ContainerImage item : items) {
            V1ContainerImageBuilder builder = new V1ContainerImageBuilder(item);
            this._visitables.remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<V1ContainerImage> items) {
        for (V1ContainerImage item : items) {
            V1ContainerImageBuilder builder = new V1ContainerImageBuilder(item);
            this._visitables.remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerImage> getImages() {
        return V1NodeStatusFluentImpl.build(this.images);
    }

    @Override
    public List<V1ContainerImage> buildImages() {
        return V1NodeStatusFluentImpl.build(this.images);
    }

    @Override
    public V1ContainerImage buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public V1ContainerImage buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public V1ContainerImage buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public V1ContainerImage buildMatchingImage(Predicate<V1ContainerImageBuilder> predicate) {
        for (V1ContainerImageBuilder item : this.images) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withImages(List<V1ContainerImage> images) {
        if (this.images != null) {
            this._visitables.removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList<V1ContainerImageBuilder>();
            for (V1ContainerImage item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(V1ContainerImage ... images) {
        this.images.clear();
        if (images != null) {
            for (V1ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> addNewImageLike(V1ContainerImage item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> setNewImageLike(int index, V1ContainerImage item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public V1NodeStatusFluent.ImagesNested<A> editMatchingImage(Predicate<V1ContainerImageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.apply(this.images.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    @Deprecated
    public V1NodeSystemInfo getNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    @Override
    public V1NodeSystemInfo buildNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    @Override
    public A withNodeInfo(V1NodeSystemInfo nodeInfo) {
        this._visitables.remove(this.nodeInfo);
        if (nodeInfo != null) {
            this.nodeInfo = new V1NodeSystemInfoBuilder(nodeInfo);
            this._visitables.add(this.nodeInfo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeInfo() {
        return this.nodeInfo != null;
    }

    @Override
    public V1NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(V1NodeSystemInfo item) {
        return new NodeInfoNestedImpl(item);
    }

    @Override
    public V1NodeStatusFluent.NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo());
    }

    @Override
    public V1NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo() != null ? this.getNodeInfo() : new V1NodeSystemInfoBuilder().build());
    }

    @Override
    public V1NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(V1NodeSystemInfo item) {
        return this.withNewNodeInfoLike(this.getNodeInfo() != null ? this.getNodeInfo() : item);
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public A addToVolumesAttached(int index, V1AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolumeBuilder>();
        }
        V1AttachedVolumeBuilder builder = new V1AttachedVolumeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.volumesAttached.add(index >= 0 ? index : this.volumesAttached.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumesAttached(int index, V1AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolumeBuilder>();
        }
        V1AttachedVolumeBuilder builder = new V1AttachedVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.volumesAttached.size()) {
            this.volumesAttached.add(builder);
        } else {
            this.volumesAttached.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumesAttached(V1AttachedVolume ... items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolumeBuilder>();
        }
        for (V1AttachedVolume item : items) {
            V1AttachedVolumeBuilder builder = new V1AttachedVolumeBuilder(item);
            this._visitables.add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumesAttached(Collection<V1AttachedVolume> items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolumeBuilder>();
        }
        for (V1AttachedVolume item : items) {
            V1AttachedVolumeBuilder builder = new V1AttachedVolumeBuilder(item);
            this._visitables.add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumesAttached(V1AttachedVolume ... items) {
        for (V1AttachedVolume item : items) {
            V1AttachedVolumeBuilder builder = new V1AttachedVolumeBuilder(item);
            this._visitables.remove(builder);
            if (this.volumesAttached == null) continue;
            this.volumesAttached.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumesAttached(Collection<V1AttachedVolume> items) {
        for (V1AttachedVolume item : items) {
            V1AttachedVolumeBuilder builder = new V1AttachedVolumeBuilder(item);
            this._visitables.remove(builder);
            if (this.volumesAttached == null) continue;
            this.volumesAttached.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1AttachedVolume> getVolumesAttached() {
        return V1NodeStatusFluentImpl.build(this.volumesAttached);
    }

    @Override
    public List<V1AttachedVolume> buildVolumesAttached() {
        return V1NodeStatusFluentImpl.build(this.volumesAttached);
    }

    @Override
    public V1AttachedVolume buildVolumesAttached(int index) {
        return this.volumesAttached.get(index).build();
    }

    @Override
    public V1AttachedVolume buildFirstVolumesAttached() {
        return this.volumesAttached.get(0).build();
    }

    @Override
    public V1AttachedVolume buildLastVolumesAttached() {
        return this.volumesAttached.get(this.volumesAttached.size() - 1).build();
    }

    @Override
    public V1AttachedVolume buildMatchingVolumesAttached(Predicate<V1AttachedVolumeBuilder> predicate) {
        for (V1AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withVolumesAttached(List<V1AttachedVolume> volumesAttached) {
        if (this.volumesAttached != null) {
            this._visitables.removeAll(this.volumesAttached);
        }
        if (volumesAttached != null) {
            this.volumesAttached = new ArrayList<V1AttachedVolumeBuilder>();
            for (V1AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        } else {
            this.volumesAttached = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumesAttached(V1AttachedVolume ... volumesAttached) {
        this.volumesAttached.clear();
        if (volumesAttached != null) {
            for (V1AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumesAttached() {
        return this.volumesAttached != null && !this.volumesAttached.isEmpty();
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached() {
        return new VolumesAttachedNestedImpl();
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(V1AttachedVolume item) {
        return new VolumesAttachedNestedImpl(-1, item);
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> setNewVolumesAttachedLike(int index, V1AttachedVolume item) {
        return new VolumesAttachedNestedImpl(index, item);
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> editVolumesAttached(int index) {
        if (this.volumesAttached.size() <= index) {
            throw new RuntimeException("Can't edit volumesAttached. Index exceeds size.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> editFirstVolumesAttached() {
        if (this.volumesAttached.size() == 0) {
            throw new RuntimeException("Can't edit first volumesAttached. The list is empty.");
        }
        return this.setNewVolumesAttachedLike(0, this.buildVolumesAttached(0));
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> editLastVolumesAttached() {
        int index = this.volumesAttached.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumesAttached. The list is empty.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    @Override
    public V1NodeStatusFluent.VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<V1AttachedVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumesAttached.size(); ++i) {
            if (!predicate.apply(this.volumesAttached.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumesAttached. No match found.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    @Override
    public A addToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumesInUse(int index, String item) {
        this.volumesInUse.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumesInUse(String ... items) {
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumesInUse(Collection<String> items) {
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumesInUse(String ... items) {
        for (String item : items) {
            if (this.volumesInUse == null) continue;
            this.volumesInUse.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumesInUse(Collection<String> items) {
        for (String item : items) {
            if (this.volumesInUse == null) continue;
            this.volumesInUse.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    @Override
    public String getVolumesInUse(int index) {
        return this.volumesInUse.get(index);
    }

    @Override
    public String getFirstVolumesInUse() {
        return this.volumesInUse.get(0);
    }

    @Override
    public String getLastVolumesInUse() {
        return this.volumesInUse.get(this.volumesInUse.size() - 1);
    }

    @Override
    public String getMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVolumesInUse(List<String> volumesInUse) {
        if (this.volumesInUse != null) {
            this._visitables.removeAll(this.volumesInUse);
        }
        if (volumesInUse != null) {
            this.volumesInUse = new ArrayList<String>();
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        } else {
            this.volumesInUse = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumesInUse(String ... volumesInUse) {
        this.volumesInUse.clear();
        if (volumesInUse != null) {
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumesInUse() {
        return this.volumesInUse != null && !this.volumesInUse.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeStatusFluentImpl that = (V1NodeStatusFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.allocatable != null ? !this.allocatable.equals(that.allocatable) : that.allocatable != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.daemonEndpoints != null ? !this.daemonEndpoints.equals(that.daemonEndpoints) : that.daemonEndpoints != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.nodeInfo != null ? !this.nodeInfo.equals(that.nodeInfo) : that.nodeInfo != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.volumesAttached != null ? !this.volumesAttached.equals(that.volumesAttached) : that.volumesAttached != null) {
            return false;
        }
        return !(this.volumesInUse != null ? !this.volumesInUse.equals(that.volumesInUse) : that.volumesInUse != null);
    }

    public class VolumesAttachedNestedImpl<N>
    extends V1AttachedVolumeFluentImpl<V1NodeStatusFluent.VolumesAttachedNested<N>>
    implements V1NodeStatusFluent.VolumesAttachedNested<N>,
    Nested<N> {
        private final V1AttachedVolumeBuilder builder;
        private final int index;

        VolumesAttachedNestedImpl(int index, V1AttachedVolume item) {
            this.index = index;
            this.builder = new V1AttachedVolumeBuilder(this, item);
        }

        VolumesAttachedNestedImpl() {
            this.index = -1;
            this.builder = new V1AttachedVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.setToVolumesAttached(this.index, this.builder.build());
        }

        @Override
        public N endVolumesAttached() {
            return this.and();
        }
    }

    public class NodeInfoNestedImpl<N>
    extends V1NodeSystemInfoFluentImpl<V1NodeStatusFluent.NodeInfoNested<N>>
    implements V1NodeStatusFluent.NodeInfoNested<N>,
    Nested<N> {
        private final V1NodeSystemInfoBuilder builder;

        NodeInfoNestedImpl(V1NodeSystemInfo item) {
            this.builder = new V1NodeSystemInfoBuilder(this, item);
        }

        NodeInfoNestedImpl() {
            this.builder = new V1NodeSystemInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.withNodeInfo(this.builder.build());
        }

        @Override
        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends V1ContainerImageFluentImpl<V1NodeStatusFluent.ImagesNested<N>>
    implements V1NodeStatusFluent.ImagesNested<N>,
    Nested<N> {
        private final V1ContainerImageBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, V1ContainerImage item) {
            this.index = index;
            this.builder = new V1ContainerImageBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class DaemonEndpointsNestedImpl<N>
    extends V1NodeDaemonEndpointsFluentImpl<V1NodeStatusFluent.DaemonEndpointsNested<N>>
    implements V1NodeStatusFluent.DaemonEndpointsNested<N>,
    Nested<N> {
        private final V1NodeDaemonEndpointsBuilder builder;

        DaemonEndpointsNestedImpl(V1NodeDaemonEndpoints item) {
            this.builder = new V1NodeDaemonEndpointsBuilder(this, item);
        }

        DaemonEndpointsNestedImpl() {
            this.builder = new V1NodeDaemonEndpointsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.withDaemonEndpoints(this.builder.build());
        }

        @Override
        public N endDaemonEndpoints() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends V1NodeConfigStatusFluentImpl<V1NodeStatusFluent.ConfigNested<N>>
    implements V1NodeStatusFluent.ConfigNested<N>,
    Nested<N> {
        private final V1NodeConfigStatusBuilder builder;

        ConfigNestedImpl(V1NodeConfigStatus item) {
            this.builder = new V1NodeConfigStatusBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new V1NodeConfigStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends V1NodeConditionFluentImpl<V1NodeStatusFluent.ConditionsNested<N>>
    implements V1NodeStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1NodeConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1NodeCondition item) {
            this.index = index;
            this.builder = new V1NodeConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1NodeConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNestedImpl<N>
    extends V1NodeAddressFluentImpl<V1NodeStatusFluent.AddressesNested<N>>
    implements V1NodeStatusFluent.AddressesNested<N>,
    Nested<N> {
        private final V1NodeAddressBuilder builder;
        private final int index;

        AddressesNestedImpl(int index, V1NodeAddress item) {
            this.index = index;
            this.builder = new V1NodeAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new V1NodeAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeStatusFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

