/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1DeleteOptionsFluent;
import io.kubernetes.client.models.V1Preconditions;
import io.kubernetes.client.models.V1PreconditionsBuilder;
import io.kubernetes.client.models.V1PreconditionsFluentImpl;

public class V1DeleteOptionsFluentImpl<A extends V1DeleteOptionsFluent<A>>
extends BaseFluent<A>
implements V1DeleteOptionsFluent<A> {
    private String apiVersion;
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private V1PreconditionsBuilder preconditions;
    private String propagationPolicy;

    public V1DeleteOptionsFluentImpl() {
    }

    public V1DeleteOptionsFluentImpl(V1DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withOrphanDependents(instance.isOrphanDependents());
        this.withPreconditions(instance.getPreconditions());
        this.withPropagationPolicy(instance.getPropagationPolicy());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Override
    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    @Override
    public A withNewGracePeriodSeconds(String arg1) {
        return this.withGracePeriodSeconds(new Long(arg1));
    }

    @Override
    public A withNewGracePeriodSeconds(long arg1) {
        return this.withGracePeriodSeconds(new Long(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Boolean isOrphanDependents() {
        return this.orphanDependents;
    }

    @Override
    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    @Override
    public A withNewOrphanDependents(boolean arg1) {
        return this.withOrphanDependents(new Boolean(arg1));
    }

    @Override
    public A withNewOrphanDependents(String arg1) {
        return this.withOrphanDependents(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public V1Preconditions getPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public V1Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public A withPreconditions(V1Preconditions preconditions) {
        this._visitables.remove(this.preconditions);
        if (preconditions != null) {
            this.preconditions = new V1PreconditionsBuilder(preconditions);
            this._visitables.add(this.preconditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreconditions() {
        return this.preconditions != null;
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNestedImpl();
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(V1Preconditions item) {
        return new PreconditionsNestedImpl(item);
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions());
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : new V1PreconditionsBuilder().build());
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(V1Preconditions item) {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : item);
    }

    @Override
    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public A withPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeleteOptionsFluentImpl that = (V1DeleteOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.gracePeriodSeconds != null ? !this.gracePeriodSeconds.equals(that.gracePeriodSeconds) : that.gracePeriodSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.orphanDependents != null ? !this.orphanDependents.equals(that.orphanDependents) : that.orphanDependents != null) {
            return false;
        }
        if (this.preconditions != null ? !this.preconditions.equals(that.preconditions) : that.preconditions != null) {
            return false;
        }
        return !(this.propagationPolicy != null ? !this.propagationPolicy.equals(that.propagationPolicy) : that.propagationPolicy != null);
    }

    public class PreconditionsNestedImpl<N>
    extends V1PreconditionsFluentImpl<V1DeleteOptionsFluent.PreconditionsNested<N>>
    implements V1DeleteOptionsFluent.PreconditionsNested<N>,
    Nested<N> {
        private final V1PreconditionsBuilder builder;

        PreconditionsNestedImpl(V1Preconditions item) {
            this.builder = new V1PreconditionsBuilder(this, item);
        }

        PreconditionsNestedImpl() {
            this.builder = new V1PreconditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DeleteOptionsFluentImpl.this.withPreconditions(this.builder.build());
        }

        @Override
        public N endPreconditions() {
            return this.and();
        }
    }
}

