/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1CounterSet;
import io.kubernetes.client.openapi.models.V1Device;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1ResourcePool;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceSliceSpec contains the information published by the driver in one ResourceSlice.")
public class V1ResourceSliceSpec {
    public static final String SERIALIZED_NAME_ALL_NODES = "allNodes";
    @SerializedName(value="allNodes")
    @Nullable
    private Boolean allNodes;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    @Nullable
    private List<V1Device> devices = new ArrayList<V1Device>();
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    @Nonnull
    private String driver;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    @Nullable
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    @Nullable
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_PER_DEVICE_NODE_SELECTION = "perDeviceNodeSelection";
    @SerializedName(value="perDeviceNodeSelection")
    @Nullable
    private Boolean perDeviceNodeSelection;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    @Nonnull
    private V1ResourcePool pool;
    public static final String SERIALIZED_NAME_SHARED_COUNTERS = "sharedCounters";
    @SerializedName(value="sharedCounters")
    @Nullable
    private List<V1CounterSet> sharedCounters = new ArrayList<V1CounterSet>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourceSliceSpec allNodes(@Nullable Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllNodes indicates that all nodes have access to the resources in the pool.  Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.")
    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(@Nullable Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1ResourceSliceSpec devices(@Nullable List<V1Device> devices) {
        this.devices = devices;
        return this;
    }

    public V1ResourceSliceSpec addDevicesItem(V1Device devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<V1Device>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Devices lists some or all of the devices in this pool.  Must not have more than 128 entries.")
    public List<V1Device> getDevices() {
        return this.devices;
    }

    public void setDevices(@Nullable List<V1Device> devices) {
        this.devices = devices;
    }

    public V1ResourceSliceSpec driver(@Nonnull String driver) {
        this.driver = driver;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(@Nonnull String driver) {
        this.driver = driver;
    }

    public V1ResourceSliceSpec nodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.  This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.  Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
    }

    public V1ResourceSliceSpec nodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1ResourceSliceSpec perDeviceNodeSelection(@Nullable Boolean perDeviceNodeSelection) {
        this.perDeviceNodeSelection = perDeviceNodeSelection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.  Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.")
    public Boolean getPerDeviceNodeSelection() {
        return this.perDeviceNodeSelection;
    }

    public void setPerDeviceNodeSelection(@Nullable Boolean perDeviceNodeSelection) {
        this.perDeviceNodeSelection = perDeviceNodeSelection;
    }

    public V1ResourceSliceSpec pool(@Nonnull V1ResourcePool pool) {
        this.pool = pool;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1ResourcePool getPool() {
        return this.pool;
    }

    public void setPool(@Nonnull V1ResourcePool pool) {
        this.pool = pool;
    }

    public V1ResourceSliceSpec sharedCounters(@Nullable List<V1CounterSet> sharedCounters) {
        this.sharedCounters = sharedCounters;
        return this;
    }

    public V1ResourceSliceSpec addSharedCountersItem(V1CounterSet sharedCountersItem) {
        if (this.sharedCounters == null) {
            this.sharedCounters = new ArrayList<V1CounterSet>();
        }
        this.sharedCounters.add(sharedCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.  The names of the SharedCounters must be unique in the ResourceSlice.  The maximum number of counters in all sets is 32.")
    public List<V1CounterSet> getSharedCounters() {
        return this.sharedCounters;
    }

    public void setSharedCounters(@Nullable List<V1CounterSet> sharedCounters) {
        this.sharedCounters = sharedCounters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceSliceSpec v1ResourceSliceSpec = (V1ResourceSliceSpec)o;
        return Objects.equals(this.allNodes, v1ResourceSliceSpec.allNodes) && Objects.equals(this.devices, v1ResourceSliceSpec.devices) && Objects.equals(this.driver, v1ResourceSliceSpec.driver) && Objects.equals(this.nodeName, v1ResourceSliceSpec.nodeName) && Objects.equals(this.nodeSelector, v1ResourceSliceSpec.nodeSelector) && Objects.equals(this.perDeviceNodeSelection, v1ResourceSliceSpec.perDeviceNodeSelection) && Objects.equals(this.pool, v1ResourceSliceSpec.pool) && Objects.equals(this.sharedCounters, v1ResourceSliceSpec.sharedCounters);
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.devices, this.driver, this.nodeName, this.nodeSelector, this.perDeviceNodeSelection, this.pool, this.sharedCounters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceSliceSpec {\n");
        sb.append("    allNodes: ").append(this.toIndentedString(this.allNodes)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    perDeviceNodeSelection: ").append(this.toIndentedString(this.perDeviceNodeSelection)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    sharedCounters: ").append(this.toIndentedString(this.sharedCounters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysharedCounters;
        int i;
        JsonArray jsonArraydevices;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourceSliceSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourceSliceSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (i = 0; i < jsonArraydevices.size(); ++i) {
                V1Device.validateJsonElement(jsonArraydevices.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR).isJsonNull()) {
            V1NodeSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR));
        }
        V1ResourcePool.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POOL));
        if (jsonObj.get(SERIALIZED_NAME_SHARED_COUNTERS) != null && !jsonObj.get(SERIALIZED_NAME_SHARED_COUNTERS).isJsonNull() && (jsonArraysharedCounters = jsonObj.getAsJsonArray(SERIALIZED_NAME_SHARED_COUNTERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SHARED_COUNTERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `sharedCounters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARED_COUNTERS).toString()));
            }
            for (i = 0; i < jsonArraysharedCounters.size(); ++i) {
                V1CounterSet.validateJsonElement(jsonArraysharedCounters.get(i));
            }
        }
    }

    public static V1ResourceSliceSpec fromJson(String jsonString) throws IOException {
        return (V1ResourceSliceSpec)JSON.getGson().fromJson(jsonString, V1ResourceSliceSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALL_NODES);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_PER_DEVICE_NODE_SELECTION);
        openapiFields.add(SERIALIZED_NAME_POOL);
        openapiFields.add(SERIALIZED_NAME_SHARED_COUNTERS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DRIVER);
        openapiRequiredFields.add(SERIALIZED_NAME_POOL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourceSliceSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourceSliceSpec.class));
            return new TypeAdapter<V1ResourceSliceSpec>(){

                public void write(JsonWriter out, V1ResourceSliceSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourceSliceSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ResourceSliceSpec.validateJsonElement(jsonElement);
                    return (V1ResourceSliceSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

