/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodCertificateProjection provides a private key and X.509 certificate in the pod filesystem.")
public class V1PodCertificateProjection {
    public static final String SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH = "certificateChainPath";
    @SerializedName(value="certificateChainPath")
    @Nullable
    private String certificateChainPath;
    public static final String SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH = "credentialBundlePath";
    @SerializedName(value="credentialBundlePath")
    @Nullable
    private String credentialBundlePath;
    public static final String SERIALIZED_NAME_KEY_PATH = "keyPath";
    @SerializedName(value="keyPath")
    @Nullable
    private String keyPath;
    public static final String SERIALIZED_NAME_KEY_TYPE = "keyType";
    @SerializedName(value="keyType")
    @Nonnull
    private String keyType;
    public static final String SERIALIZED_NAME_MAX_EXPIRATION_SECONDS = "maxExpirationSeconds";
    @SerializedName(value="maxExpirationSeconds")
    @Nullable
    private Integer maxExpirationSeconds;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    @Nonnull
    private String signerName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodCertificateProjection certificateChainPath(@Nullable String certificateChainPath) {
        this.certificateChainPath = certificateChainPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Write the certificate chain at this path in the projected volume.  Most applications should use credentialBundlePath.  When using keyPath and certificateChainPath, your application needs to check that the key and leaf certificate are consistent, because it is possible to read the files mid-rotation.")
    public String getCertificateChainPath() {
        return this.certificateChainPath;
    }

    public void setCertificateChainPath(@Nullable String certificateChainPath) {
        this.certificateChainPath = certificateChainPath;
    }

    public V1PodCertificateProjection credentialBundlePath(@Nullable String credentialBundlePath) {
        this.credentialBundlePath = credentialBundlePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Write the credential bundle at this path in the projected volume.  The credential bundle is a single file that contains multiple PEM blocks. The first PEM block is a PRIVATE KEY block, containing a PKCS#8 private key.  The remaining blocks are CERTIFICATE blocks, containing the issued certificate chain from the signer (leaf and any intermediates).  Using credentialBundlePath lets your Pod's application code make a single atomic read that retrieves a consistent key and certificate chain.  If you project them to separate files, your application code will need to additionally check that the leaf certificate was issued to the key.")
    public String getCredentialBundlePath() {
        return this.credentialBundlePath;
    }

    public void setCredentialBundlePath(@Nullable String credentialBundlePath) {
        this.credentialBundlePath = credentialBundlePath;
    }

    public V1PodCertificateProjection keyPath(@Nullable String keyPath) {
        this.keyPath = keyPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Write the key at this path in the projected volume.  Most applications should use credentialBundlePath.  When using keyPath and certificateChainPath, your application needs to check that the key and leaf certificate are consistent, because it is possible to read the files mid-rotation.")
    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(@Nullable String keyPath) {
        this.keyPath = keyPath;
    }

    public V1PodCertificateProjection keyType(@Nonnull String keyType) {
        this.keyType = keyType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of keypair Kubelet will generate for the pod.  Valid values are \"RSA3072\", \"RSA4096\", \"ECDSAP256\", \"ECDSAP384\", \"ECDSAP521\", and \"ED25519\".")
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(@Nonnull String keyType) {
        this.keyType = keyType;
    }

    public V1PodCertificateProjection maxExpirationSeconds(@Nullable Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="maxExpirationSeconds is the maximum lifetime permitted for the certificate.  Kubelet copies this value verbatim into the PodCertificateRequests it generates for this projection.  If omitted, kube-apiserver will set it to 86400(24 hours). kube-apiserver will reject values shorter than 3600 (1 hour).  The maximum allowable value is 7862400 (91 days).  The signer implementation is then free to issue a certificate with any lifetime *shorter* than MaxExpirationSeconds, but no shorter than 3600 seconds (1 hour).  This constraint is enforced by kube-apiserver. `kubernetes.io` signers will never issue certificates with a lifetime longer than 24 hours.")
    public Integer getMaxExpirationSeconds() {
        return this.maxExpirationSeconds;
    }

    public void setMaxExpirationSeconds(@Nullable Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
    }

    public V1PodCertificateProjection signerName(@Nonnull String signerName) {
        this.signerName = signerName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Kubelet's generated CSRs will be addressed to this signer.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(@Nonnull String signerName) {
        this.signerName = signerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodCertificateProjection v1PodCertificateProjection = (V1PodCertificateProjection)o;
        return Objects.equals(this.certificateChainPath, v1PodCertificateProjection.certificateChainPath) && Objects.equals(this.credentialBundlePath, v1PodCertificateProjection.credentialBundlePath) && Objects.equals(this.keyPath, v1PodCertificateProjection.keyPath) && Objects.equals(this.keyType, v1PodCertificateProjection.keyType) && Objects.equals(this.maxExpirationSeconds, v1PodCertificateProjection.maxExpirationSeconds) && Objects.equals(this.signerName, v1PodCertificateProjection.signerName);
    }

    public int hashCode() {
        return Objects.hash(this.certificateChainPath, this.credentialBundlePath, this.keyPath, this.keyType, this.maxExpirationSeconds, this.signerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodCertificateProjection {\n");
        sb.append("    certificateChainPath: ").append(this.toIndentedString(this.certificateChainPath)).append("\n");
        sb.append("    credentialBundlePath: ").append(this.toIndentedString(this.credentialBundlePath)).append("\n");
        sb.append("    keyPath: ").append(this.toIndentedString(this.keyPath)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString(this.keyType)).append("\n");
        sb.append("    maxExpirationSeconds: ").append(this.toIndentedString(this.maxExpirationSeconds)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodCertificateProjection is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodCertificateProjection` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH) != null && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `certificateChainPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH) != null && !jsonObj.get(SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `credentialBundlePath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY_PATH) != null && !jsonObj.get(SERIALIZED_NAME_KEY_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KEY_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `keyPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `keyType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `signerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNER_NAME).toString()));
        }
    }

    public static V1PodCertificateProjection fromJson(String jsonString) throws IOException {
        return (V1PodCertificateProjection)JSON.getGson().fromJson(jsonString, V1PodCertificateProjection.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH);
        openapiFields.add(SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH);
        openapiFields.add(SERIALIZED_NAME_KEY_PATH);
        openapiFields.add(SERIALIZED_NAME_KEY_TYPE);
        openapiFields.add(SERIALIZED_NAME_MAX_EXPIRATION_SECONDS);
        openapiFields.add(SERIALIZED_NAME_SIGNER_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGNER_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodCertificateProjection.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodCertificateProjection.class));
            return new TypeAdapter<V1PodCertificateProjection>(){

                public void write(JsonWriter out, V1PodCertificateProjection value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodCertificateProjection read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodCertificateProjection.validateJsonElement(jsonElement);
                    return (V1PodCertificateProjection)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

