/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelectorTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.")
public class V1NodeSelector {
    public static final String SERIALIZED_NAME_NODE_SELECTOR_TERMS = "nodeSelectorTerms";
    @SerializedName(value="nodeSelectorTerms")
    @Nonnull
    private List<V1NodeSelectorTerm> nodeSelectorTerms = new ArrayList<V1NodeSelectorTerm>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NodeSelector nodeSelectorTerms(@Nonnull List<V1NodeSelectorTerm> nodeSelectorTerms) {
        this.nodeSelectorTerms = nodeSelectorTerms;
        return this;
    }

    public V1NodeSelector addNodeSelectorTermsItem(V1NodeSelectorTerm nodeSelectorTermsItem) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList<V1NodeSelectorTerm>();
        }
        this.nodeSelectorTerms.add(nodeSelectorTermsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required. A list of node selector terms. The terms are ORed.")
    public List<V1NodeSelectorTerm> getNodeSelectorTerms() {
        return this.nodeSelectorTerms;
    }

    public void setNodeSelectorTerms(@Nonnull List<V1NodeSelectorTerm> nodeSelectorTerms) {
        this.nodeSelectorTerms = nodeSelectorTerms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeSelector v1NodeSelector = (V1NodeSelector)o;
        return Objects.equals(this.nodeSelectorTerms, v1NodeSelector.nodeSelectorTerms);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelectorTerms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeSelector {\n");
        sb.append("    nodeSelectorTerms: ").append(this.toIndentedString(this.nodeSelectorTerms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NodeSelector is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NodeSelector` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR_TERMS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeSelectorTerms` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR_TERMS).toString()));
        }
        JsonArray jsonArraynodeSelectorTerms = jsonObj.getAsJsonArray(SERIALIZED_NAME_NODE_SELECTOR_TERMS);
        for (int i = 0; i < jsonArraynodeSelectorTerms.size(); ++i) {
            V1NodeSelectorTerm.validateJsonElement(jsonArraynodeSelectorTerms.get(i));
        }
    }

    public static V1NodeSelector fromJson(String jsonString) throws IOException {
        return (V1NodeSelector)JSON.getGson().fromJson(jsonString, V1NodeSelector.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR_TERMS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NODE_SELECTOR_TERMS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NodeSelector.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NodeSelector.class));
            return new TypeAdapter<V1NodeSelector>(){

                public void write(JsonWriter out, V1NodeSelector value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NodeSelector read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NodeSelector.validateJsonElement(jsonElement);
                    return (V1NodeSelector)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

