/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1HTTPHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="HTTPGetAction describes an action based on HTTP Get requests.")
public class V1HTTPGetAction {
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    @Nullable
    private String host;
    public static final String SERIALIZED_NAME_HTTP_HEADERS = "httpHeaders";
    @SerializedName(value="httpHeaders")
    @Nullable
    private List<V1HTTPHeader> httpHeaders = new ArrayList<V1HTTPHeader>();
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    @Nullable
    private String path;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    @Nonnull
    private IntOrString port;
    public static final String SERIALIZED_NAME_SCHEME = "scheme";
    @SerializedName(value="scheme")
    @Nullable
    private String scheme;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1HTTPGetAction host(@Nullable String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.")
    public String getHost() {
        return this.host;
    }

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public V1HTTPGetAction httpHeaders(@Nullable List<V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public V1HTTPGetAction addHttpHeadersItem(V1HTTPHeader httpHeadersItem) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeader>();
        }
        this.httpHeaders.add(httpHeadersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom headers to set in the request. HTTP allows repeated headers.")
    public List<V1HTTPHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(@Nullable List<V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public V1HTTPGetAction path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to access on the HTTP server.")
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public V1HTTPGetAction port(@Nonnull IntOrString port) {
        this.port = port;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(@Nonnull IntOrString port) {
        this.port = port;
    }

    public V1HTTPGetAction scheme(@Nullable String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scheme to use for connecting to the host. Defaults to HTTP.")
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(@Nullable String scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPGetAction v1HTTPGetAction = (V1HTTPGetAction)o;
        return Objects.equals(this.host, v1HTTPGetAction.host) && Objects.equals(this.httpHeaders, v1HTTPGetAction.httpHeaders) && Objects.equals(this.path, v1HTTPGetAction.path) && Objects.equals(this.port, v1HTTPGetAction.port) && Objects.equals(this.scheme, v1HTTPGetAction.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HTTPGetAction {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    httpHeaders: ").append(this.toIndentedString(this.httpHeaders)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayhttpHeaders;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1HTTPGetAction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1HTTPGetAction` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_HOST) != null && !jsonObj.get(SERIALIZED_NAME_HOST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `host` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HTTP_HEADERS) != null && !jsonObj.get(SERIALIZED_NAME_HTTP_HEADERS).isJsonNull() && (jsonArrayhttpHeaders = jsonObj.getAsJsonArray(SERIALIZED_NAME_HTTP_HEADERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HTTP_HEADERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `httpHeaders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HTTP_HEADERS).toString()));
            }
            for (int i = 0; i < jsonArrayhttpHeaders.size(); ++i) {
                V1HTTPHeader.validateJsonElement(jsonArrayhttpHeaders.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PORT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `port` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEME) != null && !jsonObj.get(SERIALIZED_NAME_SCHEME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCHEME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scheme` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCHEME).toString()));
        }
    }

    public static V1HTTPGetAction fromJson(String jsonString) throws IOException {
        return (V1HTTPGetAction)JSON.getGson().fromJson(jsonString, V1HTTPGetAction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HOST);
        openapiFields.add(SERIALIZED_NAME_HTTP_HEADERS);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_PORT);
        openapiFields.add(SERIALIZED_NAME_SCHEME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PORT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1HTTPGetAction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1HTTPGetAction.class));
            return new TypeAdapter<V1HTTPGetAction>(){

                public void write(JsonWriter out, V1HTTPGetAction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1HTTPGetAction read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1HTTPGetAction.validateJsonElement(jsonElement);
                    return (V1HTTPGetAction)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

