/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1PodDisruptionBudget;
import io.kubernetes.client.openapi.models.V1PodDisruptionBudgetList;
import io.kubernetes.client.openapi.models.V1Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PolicyV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PolicyV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public PolicyV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createNamespacedPodDisruptionBudgetCall(@Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1PodDisruptionBudget localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedPodDisruptionBudget(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedPodDisruptionBudget(Async)");
        }
        return this.createNamespacedPodDisruptionBudgetCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> createNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedPodDisruptionBudgetValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedPodDisruptionBudgetAsync(@Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedPodDisruptionBudgetValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedPodDisruptionBudgetRequest createNamespacedPodDisruptionBudget(@Nonnull String namespace, @Nonnull V1PodDisruptionBudget body) {
        return new APIcreateNamespacedPodDisruptionBudgetRequest(namespace, body);
    }

    private Call deleteCollectionNamespacedPodDisruptionBudgetCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedPodDisruptionBudget(Async)");
        }
        return this.deleteCollectionNamespacedPodDisruptionBudgetCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedPodDisruptionBudgetValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedPodDisruptionBudgetAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedPodDisruptionBudgetValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest deleteCollectionNamespacedPodDisruptionBudget(@Nonnull String namespace) {
        return new APIdeleteCollectionNamespacedPodDisruptionBudgetRequest(namespace);
    }

    private Call deleteNamespacedPodDisruptionBudgetCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedPodDisruptionBudget(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedPodDisruptionBudget(Async)");
        }
        return this.deleteNamespacedPodDisruptionBudgetCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedPodDisruptionBudgetAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedPodDisruptionBudgetRequest deleteNamespacedPodDisruptionBudget(@Nonnull String name, @Nonnull String namespace) {
        return new APIdeleteNamespacedPodDisruptionBudgetRequest(name, namespace);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/policy/v1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listNamespacedPodDisruptionBudgetCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedPodDisruptionBudget(Async)");
        }
        return this.listNamespacedPodDisruptionBudgetCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1PodDisruptionBudgetList> listNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedPodDisruptionBudgetValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudgetList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedPodDisruptionBudgetAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1PodDisruptionBudgetList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedPodDisruptionBudgetValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudgetList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedPodDisruptionBudgetRequest listNamespacedPodDisruptionBudget(@Nonnull String namespace) {
        return new APIlistNamespacedPodDisruptionBudgetRequest(namespace);
    }

    private Call listPodDisruptionBudgetForAllNamespacesCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/policy/v1/poddisruptionbudgets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPodDisruptionBudgetForAllNamespacesValidateBeforeCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listPodDisruptionBudgetForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1PodDisruptionBudgetList> listPodDisruptionBudgetForAllNamespacesWithHttpInfo(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listPodDisruptionBudgetForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudgetList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPodDisruptionBudgetForAllNamespacesAsync(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1PodDisruptionBudgetList> _callback) throws ApiException {
        Call localVarCall = this.listPodDisruptionBudgetForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudgetList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPodDisruptionBudgetForAllNamespacesRequest listPodDisruptionBudgetForAllNamespaces() {
        return new APIlistPodDisruptionBudgetForAllNamespacesRequest();
    }

    private Call patchNamespacedPodDisruptionBudgetCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedPodDisruptionBudget(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedPodDisruptionBudget(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedPodDisruptionBudget(Async)");
        }
        return this.patchNamespacedPodDisruptionBudgetCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> patchNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedPodDisruptionBudgetAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedPodDisruptionBudgetRequest patchNamespacedPodDisruptionBudget(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedPodDisruptionBudgetRequest(name, namespace, body);
    }

    private Call patchNamespacedPodDisruptionBudgetStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedPodDisruptionBudgetStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedPodDisruptionBudgetStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedPodDisruptionBudgetStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedPodDisruptionBudgetStatus(Async)");
        }
        return this.patchNamespacedPodDisruptionBudgetStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> patchNamespacedPodDisruptionBudgetStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedPodDisruptionBudgetStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedPodDisruptionBudgetStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedPodDisruptionBudgetStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedPodDisruptionBudgetStatusRequest patchNamespacedPodDisruptionBudgetStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedPodDisruptionBudgetStatusRequest(name, namespace, body);
    }

    private Call readNamespacedPodDisruptionBudgetCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedPodDisruptionBudget(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedPodDisruptionBudget(Async)");
        }
        return this.readNamespacedPodDisruptionBudgetCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> readNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedPodDisruptionBudgetAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedPodDisruptionBudgetRequest readNamespacedPodDisruptionBudget(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedPodDisruptionBudgetRequest(name, namespace);
    }

    private Call readNamespacedPodDisruptionBudgetStatusCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedPodDisruptionBudgetStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedPodDisruptionBudgetStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedPodDisruptionBudgetStatus(Async)");
        }
        return this.readNamespacedPodDisruptionBudgetStatusCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> readNamespacedPodDisruptionBudgetStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedPodDisruptionBudgetStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedPodDisruptionBudgetStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedPodDisruptionBudgetStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedPodDisruptionBudgetStatusRequest readNamespacedPodDisruptionBudgetStatus(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedPodDisruptionBudgetStatusRequest(name, namespace);
    }

    private Call replaceNamespacedPodDisruptionBudgetCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1PodDisruptionBudget localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedPodDisruptionBudgetValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedPodDisruptionBudget(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedPodDisruptionBudget(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedPodDisruptionBudget(Async)");
        }
        return this.replaceNamespacedPodDisruptionBudgetCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> replaceNamespacedPodDisruptionBudgetWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedPodDisruptionBudgetAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodDisruptionBudgetValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedPodDisruptionBudgetRequest replaceNamespacedPodDisruptionBudget(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body) {
        return new APIreplaceNamespacedPodDisruptionBudgetRequest(name, namespace, body);
    }

    private Call replaceNamespacedPodDisruptionBudgetStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1PodDisruptionBudget localVarPostBody = body;
        String localVarPath = "/apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedPodDisruptionBudgetStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedPodDisruptionBudgetStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedPodDisruptionBudgetStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedPodDisruptionBudgetStatus(Async)");
        }
        return this.replaceNamespacedPodDisruptionBudgetStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1PodDisruptionBudget> replaceNamespacedPodDisruptionBudgetStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodDisruptionBudgetStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedPodDisruptionBudgetStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodDisruptionBudgetStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1PodDisruptionBudget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedPodDisruptionBudgetStatusRequest replaceNamespacedPodDisruptionBudgetStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1PodDisruptionBudget body) {
        return new APIreplaceNamespacedPodDisruptionBudgetStatusRequest(name, namespace, body);
    }

    public class APIcreateNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1PodDisruptionBudget body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedPodDisruptionBudgetRequest(@Nonnull String namespace, V1PodDisruptionBudget body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedPodDisruptionBudgetRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedPodDisruptionBudgetRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedPodDisruptionBudgetRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.createNamespacedPodDisruptionBudgetCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.createNamespacedPodDisruptionBudgetWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.createNamespacedPodDisruptionBudgetWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.createNamespacedPodDisruptionBudgetAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedPodDisruptionBudgetRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedPodDisruptionBudgetRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.deleteCollectionNamespacedPodDisruptionBudgetCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = PolicyV1Api.this.deleteCollectionNamespacedPodDisruptionBudgetWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.deleteCollectionNamespacedPodDisruptionBudgetWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return PolicyV1Api.this.deleteCollectionNamespacedPodDisruptionBudgetAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedPodDisruptionBudgetRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedPodDisruptionBudgetRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.deleteNamespacedPodDisruptionBudgetCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = PolicyV1Api.this.deleteNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.deleteNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return PolicyV1Api.this.deleteNamespacedPodDisruptionBudgetAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = PolicyV1Api.this.getAPIResourcesWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return PolicyV1Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedPodDisruptionBudgetRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedPodDisruptionBudgetRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.listNamespacedPodDisruptionBudgetCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1PodDisruptionBudgetList execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudgetList> localVarResp = PolicyV1Api.this.listNamespacedPodDisruptionBudgetWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudgetList> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.listNamespacedPodDisruptionBudgetWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudgetList> _callback) throws ApiException {
            return PolicyV1Api.this.listNamespacedPodDisruptionBudgetAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistPodDisruptionBudgetForAllNamespacesRequest {
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String pretty;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistPodDisruptionBudgetForAllNamespacesRequest() {
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistPodDisruptionBudgetForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.listPodDisruptionBudgetForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1PodDisruptionBudgetList execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudgetList> localVarResp = PolicyV1Api.this.listPodDisruptionBudgetForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudgetList> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.listPodDisruptionBudgetForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudgetList> _callback) throws ApiException {
            return PolicyV1Api.this.listPodDisruptionBudgetForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedPodDisruptionBudgetRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.patchNamespacedPodDisruptionBudgetCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.patchNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.patchNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.patchNamespacedPodDisruptionBudgetAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedPodDisruptionBudgetStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedPodDisruptionBudgetStatusRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedPodDisruptionBudgetStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedPodDisruptionBudgetStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.patchNamespacedPodDisruptionBudgetStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.patchNamespacedPodDisruptionBudgetStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.patchNamespacedPodDisruptionBudgetStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.patchNamespacedPodDisruptionBudgetStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedPodDisruptionBudgetRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.readNamespacedPodDisruptionBudgetCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.readNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.readNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.readNamespacedPodDisruptionBudgetAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedPodDisruptionBudgetStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedPodDisruptionBudgetStatusRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedPodDisruptionBudgetStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.readNamespacedPodDisruptionBudgetStatusCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.readNamespacedPodDisruptionBudgetStatusWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.readNamespacedPodDisruptionBudgetStatusWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.readNamespacedPodDisruptionBudgetStatusAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreplaceNamespacedPodDisruptionBudgetRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1PodDisruptionBudget body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedPodDisruptionBudgetRequest(@Nonnull String name, @Nonnull String namespace, V1PodDisruptionBudget body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedPodDisruptionBudgetRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedPodDisruptionBudgetRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedPodDisruptionBudgetRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedPodDisruptionBudgetRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedPodDisruptionBudgetStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1PodDisruptionBudget body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedPodDisruptionBudgetStatusRequest(@Nonnull String name, @Nonnull String namespace, V1PodDisruptionBudget body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedPodDisruptionBudgetStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedPodDisruptionBudgetStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedPodDisruptionBudgetStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedPodDisruptionBudgetStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1PodDisruptionBudget execute() throws ApiException {
            ApiResponse<V1PodDisruptionBudget> localVarResp = PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1PodDisruptionBudget> executeWithHttpInfo() throws ApiException {
            return PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1PodDisruptionBudget> _callback) throws ApiException {
            return PolicyV1Api.this.replaceNamespacedPodDisruptionBudgetStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

