/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourcePool describes the pool that ResourceSlices belong to.")
public class V1beta2ResourcePool {
    public static final String SERIALIZED_NAME_GENERATION = "generation";
    @SerializedName(value="generation")
    @Nonnull
    private Long generation;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_RESOURCE_SLICE_COUNT = "resourceSliceCount";
    @SerializedName(value="resourceSliceCount")
    @Nonnull
    private Long resourceSliceCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2ResourcePool generation(@Nonnull Long generation) {
        this.generation = generation;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.  Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.")
    public Long getGeneration() {
        return this.generation;
    }

    public void setGeneration(@Nonnull Long generation) {
        this.generation = generation;
    }

    public V1beta2ResourcePool name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.  It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1beta2ResourcePool resourceSliceCount(@Nonnull Long resourceSliceCount) {
        this.resourceSliceCount = resourceSliceCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.  Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.")
    public Long getResourceSliceCount() {
        return this.resourceSliceCount;
    }

    public void setResourceSliceCount(@Nonnull Long resourceSliceCount) {
        this.resourceSliceCount = resourceSliceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2ResourcePool v1beta2ResourcePool = (V1beta2ResourcePool)o;
        return Objects.equals(this.generation, v1beta2ResourcePool.generation) && Objects.equals(this.name, v1beta2ResourcePool.name) && Objects.equals(this.resourceSliceCount, v1beta2ResourcePool.resourceSliceCount);
    }

    public int hashCode() {
        return Objects.hash(this.generation, this.name, this.resourceSliceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2ResourcePool {\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceSliceCount: ").append(this.toIndentedString(this.resourceSliceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2ResourcePool is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2ResourcePool` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static V1beta2ResourcePool fromJson(String jsonString) throws IOException {
        return (V1beta2ResourcePool)JSON.getGson().fromJson(jsonString, V1beta2ResourcePool.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GENERATION);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_SLICE_COUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GENERATION);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_SLICE_COUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2ResourcePool.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2ResourcePool.class));
            return new TypeAdapter<V1beta2ResourcePool>(){

                public void write(JsonWriter out, V1beta2ResourcePool value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2ResourcePool read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2ResourcePool.validateJsonElement(jsonElement);
                    return (V1beta2ResourcePool)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

