/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a StorageOS persistent volume resource.")
public class V1StorageOSPersistentVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    @Nullable
    private String fsType;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    @Nullable
    private V1ObjectReference secretRef;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    @Nullable
    private String volumeName;
    public static final String SERIALIZED_NAME_VOLUME_NAMESPACE = "volumeNamespace";
    @SerializedName(value="volumeNamespace")
    @Nullable
    private String volumeNamespace;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1StorageOSPersistentVolumeSource fsType(@Nullable String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(@Nullable String fsType) {
        this.fsType = fsType;
    }

    public V1StorageOSPersistentVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1StorageOSPersistentVolumeSource secretRef(@Nullable V1ObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(@Nullable V1ObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1StorageOSPersistentVolumeSource volumeName(@Nullable String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(@Nullable String volumeName) {
        this.volumeName = volumeName;
    }

    public V1StorageOSPersistentVolumeSource volumeNamespace(@Nullable String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \"default\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.")
    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    public void setVolumeNamespace(@Nullable String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StorageOSPersistentVolumeSource v1StorageOSPersistentVolumeSource = (V1StorageOSPersistentVolumeSource)o;
        return Objects.equals(this.fsType, v1StorageOSPersistentVolumeSource.fsType) && Objects.equals(this.readOnly, v1StorageOSPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, v1StorageOSPersistentVolumeSource.secretRef) && Objects.equals(this.volumeName, v1StorageOSPersistentVolumeSource.volumeName) && Objects.equals(this.volumeNamespace, v1StorageOSPersistentVolumeSource.volumeNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeName, this.volumeNamespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StorageOSPersistentVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("    volumeNamespace: ").append(this.toIndentedString(this.volumeNamespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1StorageOSPersistentVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1StorageOSPersistentVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_SECRET_REF).isJsonNull()) {
            V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECRET_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeNamespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_NAMESPACE).toString()));
        }
    }

    public static V1StorageOSPersistentVolumeSource fromJson(String jsonString) throws IOException {
        return (V1StorageOSPersistentVolumeSource)JSON.getGson().fromJson(jsonString, V1StorageOSPersistentVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FS_TYPE);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_VOLUME_NAME);
        openapiFields.add(SERIALIZED_NAME_VOLUME_NAMESPACE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1StorageOSPersistentVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1StorageOSPersistentVolumeSource.class));
            return new TypeAdapter<V1StorageOSPersistentVolumeSource>(){

                public void write(JsonWriter out, V1StorageOSPersistentVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1StorageOSPersistentVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1StorageOSPersistentVolumeSource.validateJsonElement(jsonElement);
                    return (V1StorageOSPersistentVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

