/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1IPAddress;
import io.kubernetes.client.openapi.models.V1IPAddressList;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressClass;
import io.kubernetes.client.openapi.models.V1IngressClassList;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1NetworkPolicy;
import io.kubernetes.client.openapi.models.V1NetworkPolicyList;
import io.kubernetes.client.openapi.models.V1ServiceCIDR;
import io.kubernetes.client.openapi.models.V1ServiceCIDRList;
import io.kubernetes.client.openapi.models.V1Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NetworkingV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworkingV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkingV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createIPAddressCall(@Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1IPAddress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIPAddressValidateBeforeCall(@Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createIPAddress(Async)");
        }
        return this.createIPAddressCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1IPAddress> createIPAddressWithHttpInfo(@Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createIPAddressValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createIPAddressAsync(@Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.createIPAddressValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateIPAddressRequest createIPAddress(@Nonnull V1IPAddress body) {
        return new APIcreateIPAddressRequest(body);
    }

    private Call createIngressClassCall(@Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1IngressClass localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIngressClassValidateBeforeCall(@Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createIngressClass(Async)");
        }
        return this.createIngressClassCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1IngressClass> createIngressClassWithHttpInfo(@Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createIngressClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createIngressClassAsync(@Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1IngressClass> _callback) throws ApiException {
        Call localVarCall = this.createIngressClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateIngressClassRequest createIngressClass(@Nonnull V1IngressClass body) {
        return new APIcreateIngressClassRequest(body);
    }

    private Call createNamespacedIngressCall(@Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Ingress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedIngressValidateBeforeCall(@Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedIngress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedIngress(Async)");
        }
        return this.createNamespacedIngressCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1Ingress> createNamespacedIngressWithHttpInfo(@Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedIngressValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedIngressAsync(@Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedIngressValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedIngressRequest createNamespacedIngress(@Nonnull String namespace, @Nonnull V1Ingress body) {
        return new APIcreateNamespacedIngressRequest(namespace, body);
    }

    private Call createNamespacedNetworkPolicyCall(@Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1NetworkPolicy localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedNetworkPolicy(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedNetworkPolicy(Async)");
        }
        return this.createNamespacedNetworkPolicyCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1NetworkPolicy> createNamespacedNetworkPolicyWithHttpInfo(@Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedNetworkPolicyValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedNetworkPolicyAsync(@Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedNetworkPolicyValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedNetworkPolicyRequest createNamespacedNetworkPolicy(@Nonnull String namespace, @Nonnull V1NetworkPolicy body) {
        return new APIcreateNamespacedNetworkPolicyRequest(namespace, body);
    }

    private Call createServiceCIDRCall(@Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1ServiceCIDR localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createServiceCIDRValidateBeforeCall(@Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createServiceCIDR(Async)");
        }
        return this.createServiceCIDRCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1ServiceCIDR> createServiceCIDRWithHttpInfo(@Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createServiceCIDRValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createServiceCIDRAsync(@Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.createServiceCIDRValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateServiceCIDRRequest createServiceCIDR(@Nonnull V1ServiceCIDR body) {
        return new APIcreateServiceCIDRRequest(body);
    }

    private Call deleteCollectionIPAddressCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionIPAddressValidateBeforeCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionIPAddressCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionIPAddressWithHttpInfo(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionIPAddressValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionIPAddressAsync(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionIPAddressValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionIPAddressRequest deleteCollectionIPAddress() {
        return new APIdeleteCollectionIPAddressRequest();
    }

    private Call deleteCollectionIngressClassCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionIngressClassValidateBeforeCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionIngressClassCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionIngressClassWithHttpInfo(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionIngressClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionIngressClassAsync(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionIngressClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionIngressClassRequest deleteCollectionIngressClass() {
        return new APIdeleteCollectionIngressClassRequest();
    }

    private Call deleteCollectionNamespacedIngressCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedIngressValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedIngress(Async)");
        }
        return this.deleteCollectionNamespacedIngressCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedIngressWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedIngressValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedIngressAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedIngressValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedIngressRequest deleteCollectionNamespacedIngress(@Nonnull String namespace) {
        return new APIdeleteCollectionNamespacedIngressRequest(namespace);
    }

    private Call deleteCollectionNamespacedNetworkPolicyCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedNetworkPolicy(Async)");
        }
        return this.deleteCollectionNamespacedNetworkPolicyCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedNetworkPolicyWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedNetworkPolicyValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedNetworkPolicyAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedNetworkPolicyValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedNetworkPolicyRequest deleteCollectionNamespacedNetworkPolicy(@Nonnull String namespace) {
        return new APIdeleteCollectionNamespacedNetworkPolicyRequest(namespace);
    }

    private Call deleteCollectionServiceCIDRCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionServiceCIDRValidateBeforeCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionServiceCIDRCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionServiceCIDRWithHttpInfo(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionServiceCIDRValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionServiceCIDRAsync(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionServiceCIDRValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionServiceCIDRRequest deleteCollectionServiceCIDR() {
        return new APIdeleteCollectionServiceCIDRRequest();
    }

    private Call deleteIPAddressCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIPAddressValidateBeforeCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteIPAddress(Async)");
        }
        return this.deleteIPAddressCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteIPAddressWithHttpInfo(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteIPAddressValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteIPAddressAsync(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteIPAddressValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteIPAddressRequest deleteIPAddress(@Nonnull String name) {
        return new APIdeleteIPAddressRequest(name);
    }

    private Call deleteIngressClassCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIngressClassValidateBeforeCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteIngressClass(Async)");
        }
        return this.deleteIngressClassCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteIngressClassWithHttpInfo(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteIngressClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteIngressClassAsync(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteIngressClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteIngressClassRequest deleteIngressClass(@Nonnull String name) {
        return new APIdeleteIngressClassRequest(name);
    }

    private Call deleteNamespacedIngressCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedIngressValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedIngress(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedIngress(Async)");
        }
        return this.deleteNamespacedIngressCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteNamespacedIngressWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedIngressValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedIngressAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedIngressValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedIngressRequest deleteNamespacedIngress(@Nonnull String name, @Nonnull String namespace) {
        return new APIdeleteNamespacedIngressRequest(name, namespace);
    }

    private Call deleteNamespacedNetworkPolicyCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedNetworkPolicy(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedNetworkPolicy(Async)");
        }
        return this.deleteNamespacedNetworkPolicyCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteNamespacedNetworkPolicyWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedNetworkPolicyValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedNetworkPolicyAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedNetworkPolicyValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedNetworkPolicyRequest deleteNamespacedNetworkPolicy(@Nonnull String name, @Nonnull String namespace) {
        return new APIdeleteNamespacedNetworkPolicyRequest(name, namespace);
    }

    private Call deleteServiceCIDRCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteServiceCIDRValidateBeforeCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteServiceCIDR(Async)");
        }
        return this.deleteServiceCIDRCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteServiceCIDRWithHttpInfo(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteServiceCIDRValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteServiceCIDRAsync(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteServiceCIDRValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteServiceCIDRRequest deleteServiceCIDR(@Nonnull String name) {
        return new APIdeleteServiceCIDRRequest(name);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listIPAddressCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIPAddressValidateBeforeCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listIPAddressCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1IPAddressList> listIPAddressWithHttpInfo(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listIPAddressValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1IPAddressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listIPAddressAsync(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1IPAddressList> _callback) throws ApiException {
        Call localVarCall = this.listIPAddressValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1IPAddressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIPAddressRequest listIPAddress() {
        return new APIlistIPAddressRequest();
    }

    private Call listIngressClassCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIngressClassValidateBeforeCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listIngressClassCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1IngressClassList> listIngressClassWithHttpInfo(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listIngressClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1IngressClassList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listIngressClassAsync(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1IngressClassList> _callback) throws ApiException {
        Call localVarCall = this.listIngressClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1IngressClassList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIngressClassRequest listIngressClass() {
        return new APIlistIngressClassRequest();
    }

    private Call listIngressForAllNamespacesCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/ingresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIngressForAllNamespacesValidateBeforeCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listIngressForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1IngressList> listIngressForAllNamespacesWithHttpInfo(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listIngressForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1IngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listIngressForAllNamespacesAsync(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1IngressList> _callback) throws ApiException {
        Call localVarCall = this.listIngressForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1IngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIngressForAllNamespacesRequest listIngressForAllNamespaces() {
        return new APIlistIngressForAllNamespacesRequest();
    }

    private Call listNamespacedIngressCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedIngressValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedIngress(Async)");
        }
        return this.listNamespacedIngressCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1IngressList> listNamespacedIngressWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedIngressValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1IngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedIngressAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1IngressList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedIngressValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1IngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedIngressRequest listNamespacedIngress(@Nonnull String namespace) {
        return new APIlistNamespacedIngressRequest(namespace);
    }

    private Call listNamespacedNetworkPolicyCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedNetworkPolicy(Async)");
        }
        return this.listNamespacedNetworkPolicyCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1NetworkPolicyList> listNamespacedNetworkPolicyWithHttpInfo(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedNetworkPolicyValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1NetworkPolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedNetworkPolicyAsync(@Nonnull String namespace, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1NetworkPolicyList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedNetworkPolicyValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedNetworkPolicyRequest listNamespacedNetworkPolicy(@Nonnull String namespace) {
        return new APIlistNamespacedNetworkPolicyRequest(namespace);
    }

    private Call listNetworkPolicyForAllNamespacesCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/networkpolicies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkPolicyForAllNamespacesValidateBeforeCall(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listNetworkPolicyForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1NetworkPolicyList> listNetworkPolicyForAllNamespacesWithHttpInfo(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNetworkPolicyForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1NetworkPolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNetworkPolicyForAllNamespacesAsync(@Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String pretty, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1NetworkPolicyList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkPolicyForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNetworkPolicyForAllNamespacesRequest listNetworkPolicyForAllNamespaces() {
        return new APIlistNetworkPolicyForAllNamespacesRequest();
    }

    private Call listServiceCIDRCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listServiceCIDRValidateBeforeCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listServiceCIDRCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1ServiceCIDRList> listServiceCIDRWithHttpInfo(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listServiceCIDRValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDRList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listServiceCIDRAsync(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1ServiceCIDRList> _callback) throws ApiException {
        Call localVarCall = this.listServiceCIDRValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDRList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistServiceCIDRRequest listServiceCIDR() {
        return new APIlistServiceCIDRRequest();
    }

    private Call patchIPAddressCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIPAddressValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIPAddress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchIPAddress(Async)");
        }
        return this.patchIPAddressCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1IPAddress> patchIPAddressWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchIPAddressAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.patchIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchIPAddressRequest patchIPAddress(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchIPAddressRequest(name, body);
    }

    private Call patchIngressClassCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIngressClassValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIngressClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchIngressClass(Async)");
        }
        return this.patchIngressClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1IngressClass> patchIngressClassWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchIngressClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchIngressClassAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1IngressClass> _callback) throws ApiException {
        Call localVarCall = this.patchIngressClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchIngressClassRequest patchIngressClass(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchIngressClassRequest(name, body);
    }

    private Call patchNamespacedIngressCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedIngressValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedIngress(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedIngress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedIngress(Async)");
        }
        return this.patchNamespacedIngressCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1Ingress> patchNamespacedIngressWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedIngressValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedIngressAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedIngressValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedIngressRequest patchNamespacedIngress(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedIngressRequest(name, namespace, body);
    }

    private Call patchNamespacedIngressStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedIngressStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedIngressStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedIngressStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedIngressStatus(Async)");
        }
        return this.patchNamespacedIngressStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1Ingress> patchNamespacedIngressStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedIngressStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedIngressStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedIngressStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedIngressStatusRequest patchNamespacedIngressStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedIngressStatusRequest(name, namespace, body);
    }

    private Call patchNamespacedNetworkPolicyCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedNetworkPolicy(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedNetworkPolicy(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedNetworkPolicy(Async)");
        }
        return this.patchNamespacedNetworkPolicyCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1NetworkPolicy> patchNamespacedNetworkPolicyWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedNetworkPolicyValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedNetworkPolicyAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedNetworkPolicyValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedNetworkPolicyRequest patchNamespacedNetworkPolicy(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Patch body) {
        return new APIpatchNamespacedNetworkPolicyRequest(name, namespace, body);
    }

    private Call patchServiceCIDRCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchServiceCIDRValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchServiceCIDR(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchServiceCIDR(Async)");
        }
        return this.patchServiceCIDRCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1ServiceCIDR> patchServiceCIDRWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchServiceCIDRAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.patchServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchServiceCIDRRequest patchServiceCIDR(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchServiceCIDRRequest(name, body);
    }

    private Call patchServiceCIDRStatusCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchServiceCIDRStatusValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchServiceCIDRStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchServiceCIDRStatus(Async)");
        }
        return this.patchServiceCIDRStatusCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1ServiceCIDR> patchServiceCIDRStatusWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchServiceCIDRStatusAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.patchServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchServiceCIDRStatusRequest patchServiceCIDRStatus(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchServiceCIDRStatusRequest(name, body);
    }

    private Call readIPAddressCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIPAddressValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIPAddress(Async)");
        }
        return this.readIPAddressCall(name, pretty, _callback);
    }

    private ApiResponse<V1IPAddress> readIPAddressWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readIPAddressValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readIPAddressAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.readIPAddressValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadIPAddressRequest readIPAddress(@Nonnull String name) {
        return new APIreadIPAddressRequest(name);
    }

    private Call readIngressClassCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIngressClassValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIngressClass(Async)");
        }
        return this.readIngressClassCall(name, pretty, _callback);
    }

    private ApiResponse<V1IngressClass> readIngressClassWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readIngressClassValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readIngressClassAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1IngressClass> _callback) throws ApiException {
        Call localVarCall = this.readIngressClassValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadIngressClassRequest readIngressClass(@Nonnull String name) {
        return new APIreadIngressClassRequest(name);
    }

    private Call readNamespacedIngressCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedIngressValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedIngress(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedIngress(Async)");
        }
        return this.readNamespacedIngressCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1Ingress> readNamespacedIngressWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedIngressValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedIngressAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedIngressValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedIngressRequest readNamespacedIngress(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedIngressRequest(name, namespace);
    }

    private Call readNamespacedIngressStatusCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedIngressStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedIngressStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedIngressStatus(Async)");
        }
        return this.readNamespacedIngressStatusCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1Ingress> readNamespacedIngressStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedIngressStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedIngressStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedIngressStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedIngressStatusRequest readNamespacedIngressStatus(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedIngressStatusRequest(name, namespace);
    }

    private Call readNamespacedNetworkPolicyCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedNetworkPolicy(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedNetworkPolicy(Async)");
        }
        return this.readNamespacedNetworkPolicyCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1NetworkPolicy> readNamespacedNetworkPolicyWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedNetworkPolicyValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedNetworkPolicyAsync(@Nonnull String name, @Nonnull String namespace, @Nullable String pretty, ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedNetworkPolicyValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedNetworkPolicyRequest readNamespacedNetworkPolicy(@Nonnull String name, @Nonnull String namespace) {
        return new APIreadNamespacedNetworkPolicyRequest(name, namespace);
    }

    private Call readServiceCIDRCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readServiceCIDRValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readServiceCIDR(Async)");
        }
        return this.readServiceCIDRCall(name, pretty, _callback);
    }

    private ApiResponse<V1ServiceCIDR> readServiceCIDRWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readServiceCIDRValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readServiceCIDRAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.readServiceCIDRValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadServiceCIDRRequest readServiceCIDR(@Nonnull String name) {
        return new APIreadServiceCIDRRequest(name);
    }

    private Call readServiceCIDRStatusCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readServiceCIDRStatusValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readServiceCIDRStatus(Async)");
        }
        return this.readServiceCIDRStatusCall(name, pretty, _callback);
    }

    private ApiResponse<V1ServiceCIDR> readServiceCIDRStatusWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readServiceCIDRStatusValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readServiceCIDRStatusAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.readServiceCIDRStatusValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadServiceCIDRStatusRequest readServiceCIDRStatus(@Nonnull String name) {
        return new APIreadServiceCIDRStatusRequest(name);
    }

    private Call replaceIPAddressCall(@Nonnull String name, @Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1IPAddress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ipaddresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceIPAddressValidateBeforeCall(@Nonnull String name, @Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceIPAddress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceIPAddress(Async)");
        }
        return this.replaceIPAddressCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1IPAddress> replaceIPAddressWithHttpInfo(@Nonnull String name, @Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceIPAddressAsync(@Nonnull String name, @Nonnull V1IPAddress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.replaceIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceIPAddressRequest replaceIPAddress(@Nonnull String name, @Nonnull V1IPAddress body) {
        return new APIreplaceIPAddressRequest(name, body);
    }

    private Call replaceIngressClassCall(@Nonnull String name, @Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1IngressClass localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/ingressclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceIngressClassValidateBeforeCall(@Nonnull String name, @Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceIngressClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceIngressClass(Async)");
        }
        return this.replaceIngressClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1IngressClass> replaceIngressClassWithHttpInfo(@Nonnull String name, @Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceIngressClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceIngressClassAsync(@Nonnull String name, @Nonnull V1IngressClass body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1IngressClass> _callback) throws ApiException {
        Call localVarCall = this.replaceIngressClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1IngressClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceIngressClassRequest replaceIngressClass(@Nonnull String name, @Nonnull V1IngressClass body) {
        return new APIreplaceIngressClassRequest(name, body);
    }

    private Call replaceNamespacedIngressCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Ingress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedIngressValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedIngress(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedIngress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedIngress(Async)");
        }
        return this.replaceNamespacedIngressCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1Ingress> replaceNamespacedIngressWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedIngressValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedIngressAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedIngressValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedIngressRequest replaceNamespacedIngress(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body) {
        return new APIreplaceNamespacedIngressRequest(name, namespace, body);
    }

    private Call replaceNamespacedIngressStatusCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Ingress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedIngressStatusValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedIngressStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedIngressStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedIngressStatus(Async)");
        }
        return this.replaceNamespacedIngressStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1Ingress> replaceNamespacedIngressStatusWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedIngressStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedIngressStatusAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1Ingress> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedIngressStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1Ingress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedIngressStatusRequest replaceNamespacedIngressStatus(@Nonnull String name, @Nonnull String namespace, @Nonnull V1Ingress body) {
        return new APIreplaceNamespacedIngressStatusRequest(name, namespace, body);
    }

    private Call replaceNamespacedNetworkPolicyCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1NetworkPolicy localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedNetworkPolicyValidateBeforeCall(@Nonnull String name, @Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedNetworkPolicy(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedNetworkPolicy(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedNetworkPolicy(Async)");
        }
        return this.replaceNamespacedNetworkPolicyCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1NetworkPolicy> replaceNamespacedNetworkPolicyWithHttpInfo(@Nonnull String name, @Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedNetworkPolicyValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedNetworkPolicyAsync(@Nonnull String name, @Nonnull String namespace, @Nonnull V1NetworkPolicy body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedNetworkPolicyValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedNetworkPolicyRequest replaceNamespacedNetworkPolicy(@Nonnull String name, @Nonnull String namespace, @Nonnull V1NetworkPolicy body) {
        return new APIreplaceNamespacedNetworkPolicyRequest(name, namespace, body);
    }

    private Call replaceServiceCIDRCall(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1ServiceCIDR localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceServiceCIDRValidateBeforeCall(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceServiceCIDR(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceServiceCIDR(Async)");
        }
        return this.replaceServiceCIDRCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1ServiceCIDR> replaceServiceCIDRWithHttpInfo(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceServiceCIDRAsync(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceServiceCIDRRequest replaceServiceCIDR(@Nonnull String name, @Nonnull V1ServiceCIDR body) {
        return new APIreplaceServiceCIDRRequest(name, body);
    }

    private Call replaceServiceCIDRStatusCall(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1ServiceCIDR localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1/servicecidrs/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceServiceCIDRStatusValidateBeforeCall(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceServiceCIDRStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceServiceCIDRStatus(Async)");
        }
        return this.replaceServiceCIDRStatusCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1ServiceCIDR> replaceServiceCIDRStatusWithHttpInfo(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceServiceCIDRStatusAsync(@Nonnull String name, @Nonnull V1ServiceCIDR body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceServiceCIDRStatusRequest replaceServiceCIDRStatus(@Nonnull String name, @Nonnull V1ServiceCIDR body) {
        return new APIreplaceServiceCIDRStatusRequest(name, body);
    }

    public class APIcreateIPAddressRequest {
        @Nonnull
        private final V1IPAddress body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateIPAddressRequest(V1IPAddress body) {
            this.body = body;
        }

        public APIcreateIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateIPAddressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateIPAddressRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateIPAddressRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.createIPAddressCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1IPAddress execute() throws ApiException {
            ApiResponse<V1IPAddress> localVarResp = NetworkingV1Api.this.createIPAddressWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1IPAddress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.createIPAddressWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1IPAddress> _callback) throws ApiException {
            return NetworkingV1Api.this.createIPAddressAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateIngressClassRequest {
        @Nonnull
        private final V1IngressClass body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateIngressClassRequest(V1IngressClass body) {
            this.body = body;
        }

        public APIcreateIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateIngressClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateIngressClassRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateIngressClassRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.createIngressClassCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1IngressClass execute() throws ApiException {
            ApiResponse<V1IngressClass> localVarResp = NetworkingV1Api.this.createIngressClassWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressClass> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.createIngressClassWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1IngressClass> _callback) throws ApiException {
            return NetworkingV1Api.this.createIngressClassAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedIngressRequest {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Ingress body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedIngressRequest(@Nonnull String namespace, V1Ingress body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedIngressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedIngressRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedIngressRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.createNamespacedIngressCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.createNamespacedIngressWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.createNamespacedIngressWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.createNamespacedIngressAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1NetworkPolicy body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedNetworkPolicyRequest(@Nonnull String namespace, V1NetworkPolicy body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedNetworkPolicyRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedNetworkPolicyRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedNetworkPolicyRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.createNamespacedNetworkPolicyCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1NetworkPolicy execute() throws ApiException {
            ApiResponse<V1NetworkPolicy> localVarResp = NetworkingV1Api.this.createNamespacedNetworkPolicyWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1NetworkPolicy> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.createNamespacedNetworkPolicyWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
            return NetworkingV1Api.this.createNamespacedNetworkPolicyAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateServiceCIDRRequest {
        @Nonnull
        private final V1ServiceCIDR body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateServiceCIDRRequest(V1ServiceCIDR body) {
            this.body = body;
        }

        public APIcreateServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateServiceCIDRRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateServiceCIDRRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateServiceCIDRRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.createServiceCIDRCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.createServiceCIDRWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.createServiceCIDRWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.createServiceCIDRAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionIPAddressRequest {
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionIPAddressRequest() {
        }

        public APIdeleteCollectionIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionIPAddressRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionIPAddressCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteCollectionIPAddressWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteCollectionIPAddressWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionIPAddressAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionIngressClassRequest {
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionIngressClassRequest() {
        }

        public APIdeleteCollectionIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionIngressClassRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionIngressClassCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteCollectionIngressClassWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteCollectionIngressClassWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionIngressClassAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedIngressRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedIngressRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedIngressRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionNamespacedIngressCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteCollectionNamespacedIngressWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteCollectionNamespacedIngressWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionNamespacedIngressAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedNetworkPolicyRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedNetworkPolicyRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionNamespacedNetworkPolicyCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteCollectionNamespacedNetworkPolicyWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteCollectionNamespacedNetworkPolicyWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionNamespacedNetworkPolicyAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionServiceCIDRRequest {
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionServiceCIDRRequest() {
        }

        public APIdeleteCollectionServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionServiceCIDRRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionServiceCIDRCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteCollectionServiceCIDRWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteCollectionServiceCIDRWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteCollectionServiceCIDRAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteIPAddressRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteIPAddressRequest(String name) {
            this.name = name;
        }

        public APIdeleteIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteIPAddressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteIPAddressRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteIPAddressRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteIPAddressRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteIPAddressRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteIPAddressRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteIPAddressCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteIPAddressWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteIPAddressWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteIPAddressAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteIngressClassRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteIngressClassRequest(String name) {
            this.name = name;
        }

        public APIdeleteIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteIngressClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteIngressClassRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteIngressClassRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteIngressClassRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteIngressClassRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteIngressClassRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteIngressClassCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteIngressClassWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteIngressClassWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteIngressClassAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedIngressRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedIngressRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedIngressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedIngressRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedIngressRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteNamespacedIngressRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedIngressRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedIngressRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteNamespacedIngressCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteNamespacedIngressWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteNamespacedIngressWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteNamespacedIngressAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedNetworkPolicyRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedNetworkPolicyRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedNetworkPolicyRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedNetworkPolicyRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteNamespacedNetworkPolicyRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedNetworkPolicyRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedNetworkPolicyRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteNamespacedNetworkPolicyCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteNamespacedNetworkPolicyAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteServiceCIDRRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteServiceCIDRRequest(String name) {
            this.name = name;
        }

        public APIdeleteServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteServiceCIDRRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteServiceCIDRRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteServiceCIDRRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteServiceCIDRRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteServiceCIDRRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteServiceCIDRRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.deleteServiceCIDRCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = NetworkingV1Api.this.deleteServiceCIDRWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.deleteServiceCIDRWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return NetworkingV1Api.this.deleteServiceCIDRAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = NetworkingV1Api.this.getAPIResourcesWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return NetworkingV1Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistIPAddressRequest {
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistIPAddressRequest() {
        }

        public APIlistIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistIPAddressRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistIPAddressRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistIPAddressRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistIPAddressRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistIPAddressRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistIPAddressRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistIPAddressRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistIPAddressRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistIPAddressRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistIPAddressRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listIPAddressCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1IPAddressList execute() throws ApiException {
            ApiResponse<V1IPAddressList> localVarResp = NetworkingV1Api.this.listIPAddressWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1IPAddressList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listIPAddressWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1IPAddressList> _callback) throws ApiException {
            return NetworkingV1Api.this.listIPAddressAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistIngressClassRequest {
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistIngressClassRequest() {
        }

        public APIlistIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistIngressClassRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistIngressClassRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistIngressClassRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistIngressClassRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistIngressClassRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistIngressClassRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistIngressClassRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistIngressClassRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistIngressClassRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistIngressClassRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listIngressClassCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1IngressClassList execute() throws ApiException {
            ApiResponse<V1IngressClassList> localVarResp = NetworkingV1Api.this.listIngressClassWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressClassList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listIngressClassWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1IngressClassList> _callback) throws ApiException {
            return NetworkingV1Api.this.listIngressClassAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistIngressForAllNamespacesRequest {
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String pretty;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistIngressForAllNamespacesRequest() {
        }

        public APIlistIngressForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistIngressForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listIngressForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1IngressList execute() throws ApiException {
            ApiResponse<V1IngressList> localVarResp = NetworkingV1Api.this.listIngressForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listIngressForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1IngressList> _callback) throws ApiException {
            return NetworkingV1Api.this.listIngressForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedIngressRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedIngressRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedIngressRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedIngressRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedIngressRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedIngressRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedIngressRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedIngressRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedIngressRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedIngressRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedIngressRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedIngressRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listNamespacedIngressCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1IngressList execute() throws ApiException {
            ApiResponse<V1IngressList> localVarResp = NetworkingV1Api.this.listNamespacedIngressWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listNamespacedIngressWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1IngressList> _callback) throws ApiException {
            return NetworkingV1Api.this.listNamespacedIngressAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedNetworkPolicyRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedNetworkPolicyRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listNamespacedNetworkPolicyCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1NetworkPolicyList execute() throws ApiException {
            ApiResponse<V1NetworkPolicyList> localVarResp = NetworkingV1Api.this.listNamespacedNetworkPolicyWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1NetworkPolicyList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listNamespacedNetworkPolicyWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1NetworkPolicyList> _callback) throws ApiException {
            return NetworkingV1Api.this.listNamespacedNetworkPolicyAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNetworkPolicyForAllNamespacesRequest {
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String pretty;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNetworkPolicyForAllNamespacesRequest() {
        }

        public APIlistNetworkPolicyForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNetworkPolicyForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listNetworkPolicyForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1NetworkPolicyList execute() throws ApiException {
            ApiResponse<V1NetworkPolicyList> localVarResp = NetworkingV1Api.this.listNetworkPolicyForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1NetworkPolicyList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listNetworkPolicyForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1NetworkPolicyList> _callback) throws ApiException {
            return NetworkingV1Api.this.listNetworkPolicyForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistServiceCIDRRequest {
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistServiceCIDRRequest() {
        }

        public APIlistServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistServiceCIDRRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistServiceCIDRRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistServiceCIDRRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistServiceCIDRRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistServiceCIDRRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistServiceCIDRRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistServiceCIDRRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistServiceCIDRRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistServiceCIDRRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistServiceCIDRRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.listServiceCIDRCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1ServiceCIDRList execute() throws ApiException {
            ApiResponse<V1ServiceCIDRList> localVarResp = NetworkingV1Api.this.listServiceCIDRWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDRList> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.listServiceCIDRWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDRList> _callback) throws ApiException {
            return NetworkingV1Api.this.listServiceCIDRAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchIPAddressRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchIPAddressRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchIPAddressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchIPAddressRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchIPAddressRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchIPAddressRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchIPAddressCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1IPAddress execute() throws ApiException {
            ApiResponse<V1IPAddress> localVarResp = NetworkingV1Api.this.patchIPAddressWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1IPAddress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchIPAddressWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1IPAddress> _callback) throws ApiException {
            return NetworkingV1Api.this.patchIPAddressAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchIngressClassRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchIngressClassRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchIngressClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchIngressClassRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchIngressClassRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchIngressClassRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchIngressClassCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1IngressClass execute() throws ApiException {
            ApiResponse<V1IngressClass> localVarResp = NetworkingV1Api.this.patchIngressClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressClass> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchIngressClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1IngressClass> _callback) throws ApiException {
            return NetworkingV1Api.this.patchIngressClassAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedIngressRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedIngressRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedIngressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedIngressRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedIngressRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedIngressRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchNamespacedIngressCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.patchNamespacedIngressWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchNamespacedIngressWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.patchNamespacedIngressAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedIngressStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedIngressStatusRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedIngressStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedIngressStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedIngressStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedIngressStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedIngressStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchNamespacedIngressStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.patchNamespacedIngressStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchNamespacedIngressStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.patchNamespacedIngressStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedNetworkPolicyRequest(@Nonnull String name, @Nonnull String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedNetworkPolicyRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedNetworkPolicyRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedNetworkPolicyRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedNetworkPolicyRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchNamespacedNetworkPolicyCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1NetworkPolicy execute() throws ApiException {
            ApiResponse<V1NetworkPolicy> localVarResp = NetworkingV1Api.this.patchNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1NetworkPolicy> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
            return NetworkingV1Api.this.patchNamespacedNetworkPolicyAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchServiceCIDRRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchServiceCIDRRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchServiceCIDRRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchServiceCIDRRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchServiceCIDRRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchServiceCIDRRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchServiceCIDRCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.patchServiceCIDRWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchServiceCIDRWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.patchServiceCIDRAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchServiceCIDRStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchServiceCIDRStatusRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchServiceCIDRStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchServiceCIDRStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchServiceCIDRStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchServiceCIDRStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchServiceCIDRStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.patchServiceCIDRStatusCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.patchServiceCIDRStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.patchServiceCIDRStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.patchServiceCIDRStatusAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadIPAddressRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadIPAddressRequest(String name) {
            this.name = name;
        }

        public APIreadIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readIPAddressCall(this.name, this.pretty, _callback);
        }

        public V1IPAddress execute() throws ApiException {
            ApiResponse<V1IPAddress> localVarResp = NetworkingV1Api.this.readIPAddressWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1IPAddress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readIPAddressWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1IPAddress> _callback) throws ApiException {
            return NetworkingV1Api.this.readIPAddressAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreadIngressClassRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadIngressClassRequest(String name) {
            this.name = name;
        }

        public APIreadIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readIngressClassCall(this.name, this.pretty, _callback);
        }

        public V1IngressClass execute() throws ApiException {
            ApiResponse<V1IngressClass> localVarResp = NetworkingV1Api.this.readIngressClassWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressClass> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readIngressClassWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1IngressClass> _callback) throws ApiException {
            return NetworkingV1Api.this.readIngressClassAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedIngressRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedIngressRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readNamespacedIngressCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.readNamespacedIngressWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readNamespacedIngressWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.readNamespacedIngressAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedIngressStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedIngressStatusRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedIngressStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readNamespacedIngressStatusCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.readNamespacedIngressStatusWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readNamespacedIngressStatusWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.readNamespacedIngressStatusAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nullable
        private String pretty;

        private APIreadNamespacedNetworkPolicyRequest(@Nonnull String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readNamespacedNetworkPolicyCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1NetworkPolicy execute() throws ApiException {
            ApiResponse<V1NetworkPolicy> localVarResp = NetworkingV1Api.this.readNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1NetworkPolicy> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
            return NetworkingV1Api.this.readNamespacedNetworkPolicyAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadServiceCIDRRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadServiceCIDRRequest(String name) {
            this.name = name;
        }

        public APIreadServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readServiceCIDRCall(this.name, this.pretty, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.readServiceCIDRWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readServiceCIDRWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.readServiceCIDRAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreadServiceCIDRStatusRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadServiceCIDRStatusRequest(String name) {
            this.name = name;
        }

        public APIreadServiceCIDRStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.readServiceCIDRStatusCall(this.name, this.pretty, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.readServiceCIDRStatusWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.readServiceCIDRStatusWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.readServiceCIDRStatusAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreplaceIPAddressRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1IPAddress body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceIPAddressRequest(@Nonnull String name, V1IPAddress body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceIPAddressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceIPAddressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceIPAddressRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceIPAddressRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceIPAddressCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1IPAddress execute() throws ApiException {
            ApiResponse<V1IPAddress> localVarResp = NetworkingV1Api.this.replaceIPAddressWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1IPAddress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceIPAddressWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1IPAddress> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceIPAddressAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceIngressClassRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1IngressClass body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceIngressClassRequest(@Nonnull String name, V1IngressClass body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceIngressClassRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceIngressClassRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceIngressClassRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceIngressClassRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceIngressClassCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1IngressClass execute() throws ApiException {
            ApiResponse<V1IngressClass> localVarResp = NetworkingV1Api.this.replaceIngressClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1IngressClass> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceIngressClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1IngressClass> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceIngressClassAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedIngressRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Ingress body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedIngressRequest(@Nonnull String name, @Nonnull String namespace, V1Ingress body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedIngressRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedIngressRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedIngressRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedIngressRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedIngressCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.replaceNamespacedIngressWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedIngressWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedIngressAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedIngressStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1Ingress body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedIngressStatusRequest(@Nonnull String name, @Nonnull String namespace, V1Ingress body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedIngressStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedIngressStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedIngressStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedIngressStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedIngressStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1Ingress execute() throws ApiException {
            ApiResponse<V1Ingress> localVarResp = NetworkingV1Api.this.replaceNamespacedIngressStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1Ingress> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedIngressStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1Ingress> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedIngressStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedNetworkPolicyRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final V1NetworkPolicy body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedNetworkPolicyRequest(@Nonnull String name, @Nonnull String namespace, V1NetworkPolicy body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedNetworkPolicyRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedNetworkPolicyRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedNetworkPolicyRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedNetworkPolicyRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedNetworkPolicyCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1NetworkPolicy execute() throws ApiException {
            ApiResponse<V1NetworkPolicy> localVarResp = NetworkingV1Api.this.replaceNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1NetworkPolicy> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedNetworkPolicyWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1NetworkPolicy> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceNamespacedNetworkPolicyAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceServiceCIDRRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1ServiceCIDR body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceServiceCIDRRequest(@Nonnull String name, V1ServiceCIDR body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceServiceCIDRRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceServiceCIDRRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceServiceCIDRRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceServiceCIDRRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceServiceCIDRCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.replaceServiceCIDRWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceServiceCIDRWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceServiceCIDRAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceServiceCIDRStatusRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1ServiceCIDR body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceServiceCIDRStatusRequest(@Nonnull String name, V1ServiceCIDR body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceServiceCIDRStatusRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceServiceCIDRStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceServiceCIDRStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceServiceCIDRStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworkingV1Api.this.replaceServiceCIDRStatusCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1ServiceCIDR execute() throws ApiException {
            ApiResponse<V1ServiceCIDR> localVarResp = NetworkingV1Api.this.replaceServiceCIDRStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1ServiceCIDR> executeWithHttpInfo() throws ApiException {
            return NetworkingV1Api.this.replaceServiceCIDRStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1ServiceCIDR> _callback) throws ApiException {
            return NetworkingV1Api.this.replaceServiceCIDRStatusAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

