/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1alpha3NetworkDeviceData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.")
public class V1alpha3AllocatedDeviceStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1Condition> conditions = null;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private Object data;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private String device;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_NETWORK_DATA = "networkData";
    @SerializedName(value="networkData")
    private V1alpha3NetworkDeviceData networkData;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    private String pool;

    public V1alpha3AllocatedDeviceStatus conditions(List<V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1alpha3AllocatedDeviceStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.")
    public List<V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1alpha3AllocatedDeviceStatus data(Object data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Data contains arbitrary driver-specific data.  The length of the raw data must be smaller or equal to 10 Ki.")
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public V1alpha3AllocatedDeviceStatus device(String device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(required=true, value="Device references one device instance via its name in the driver's resource pool. It must be a DNS label.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public V1alpha3AllocatedDeviceStatus driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1alpha3AllocatedDeviceStatus networkData(V1alpha3NetworkDeviceData networkData) {
        this.networkData = networkData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha3NetworkDeviceData getNetworkData() {
        return this.networkData;
    }

    public void setNetworkData(V1alpha3NetworkDeviceData networkData) {
        this.networkData = networkData;
    }

    public V1alpha3AllocatedDeviceStatus pool(String pool) {
        this.pool = pool;
        return this;
    }

    @ApiModelProperty(required=true, value="This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).  Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3AllocatedDeviceStatus v1alpha3AllocatedDeviceStatus = (V1alpha3AllocatedDeviceStatus)o;
        return Objects.equals(this.conditions, v1alpha3AllocatedDeviceStatus.conditions) && Objects.equals(this.data, v1alpha3AllocatedDeviceStatus.data) && Objects.equals(this.device, v1alpha3AllocatedDeviceStatus.device) && Objects.equals(this.driver, v1alpha3AllocatedDeviceStatus.driver) && Objects.equals(this.networkData, v1alpha3AllocatedDeviceStatus.networkData) && Objects.equals(this.pool, v1alpha3AllocatedDeviceStatus.pool);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.data, this.device, this.driver, this.networkData, this.pool);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3AllocatedDeviceStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    networkData: ").append(this.toIndentedString(this.networkData)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

