/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClass;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClassList;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaim;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimList;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimTemplate;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimTemplateList;
import io.kubernetes.client.openapi.models.V1alpha3ResourceSlice;
import io.kubernetes.client.openapi.models.V1alpha3ResourceSliceList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ResourceV1alpha3Api {
    private ApiClient localVarApiClient;

    public ResourceV1alpha3Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourceV1alpha3Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createDeviceClassCall(V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3DeviceClass localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDeviceClassValidateBeforeCall(V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDeviceClass(Async)");
        }
        Call localVarCall = this.createDeviceClassCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3DeviceClass createDeviceClass(V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3DeviceClass> localVarResp = this.createDeviceClassWithHttpInfo(body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3DeviceClass> createDeviceClassWithHttpInfo(V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createDeviceClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createDeviceClassAsync(V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.createDeviceClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNamespacedResourceClaimCall(String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedResourceClaimValidateBeforeCall(String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.createNamespacedResourceClaimCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim createNamespacedResourceClaim(String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.createNamespacedResourceClaimWithHttpInfo(namespace, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> createNamespacedResourceClaimWithHttpInfo(String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNamespacedResourceClaimAsync(String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNamespacedResourceClaimTemplateCall(String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceClaimTemplate localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedResourceClaimTemplateValidateBeforeCall(String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.createNamespacedResourceClaimTemplateCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplate createNamespacedResourceClaimTemplate(String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplate> localVarResp = this.createNamespacedResourceClaimTemplateWithHttpInfo(namespace, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplate> createNamespacedResourceClaimTemplateWithHttpInfo(String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimTemplateValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNamespacedResourceClaimTemplateAsync(String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimTemplateValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createResourceSliceCall(V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceSlice localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createResourceSliceValidateBeforeCall(V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createResourceSlice(Async)");
        }
        Call localVarCall = this.createResourceSliceCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceSlice createResourceSlice(V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceSlice> localVarResp = this.createResourceSliceWithHttpInfo(body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceSlice> createResourceSliceWithHttpInfo(V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createResourceSliceValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createResourceSliceAsync(V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.createResourceSliceValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionDeviceClassCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionDeviceClassValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceClassCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionDeviceClass(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionDeviceClassWithHttpInfo(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionDeviceClassWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionDeviceClassAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionNamespacedResourceClaimCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedResourceClaimValidateBeforeCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionNamespacedResourceClaim(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionNamespacedResourceClaimWithHttpInfo(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionNamespacedResourceClaimWithHttpInfo(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionNamespacedResourceClaimAsync(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionNamespacedResourceClaimTemplateCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionNamespacedResourceClaimTemplate(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionNamespacedResourceClaimTemplateAsync(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionResourceSliceCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionResourceSliceValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceSliceCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionResourceSlice(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionResourceSliceWithHttpInfo(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionResourceSliceWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceSliceValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionResourceSliceAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceSliceValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDeviceClassCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDeviceClassValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDeviceClass(Async)");
        }
        Call localVarCall = this.deleteDeviceClassCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1alpha3DeviceClass deleteDeviceClass(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1alpha3DeviceClass> localVarResp = this.deleteDeviceClassWithHttpInfo(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3DeviceClass> deleteDeviceClassWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteDeviceClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDeviceClassAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha3DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.deleteDeviceClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNamespacedResourceClaimCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedResourceClaimValidateBeforeCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.deleteNamespacedResourceClaimCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim deleteNamespacedResourceClaim(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.deleteNamespacedResourceClaimWithHttpInfo(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> deleteNamespacedResourceClaimWithHttpInfo(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNamespacedResourceClaimAsync(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNamespacedResourceClaimTemplateCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplate deleteNamespacedResourceClaimTemplate(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplate> localVarResp = this.deleteNamespacedResourceClaimTemplateWithHttpInfo(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplate> deleteNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNamespacedResourceClaimTemplateAsync(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha3ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteResourceSliceCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteResourceSliceValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteResourceSlice(Async)");
        }
        Call localVarCall = this.deleteResourceSliceCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceSlice deleteResourceSlice(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1alpha3ResourceSlice> localVarResp = this.deleteResourceSliceWithHttpInfo(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceSlice> deleteResourceSliceWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteResourceSliceValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteResourceSliceAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha3ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.deleteResourceSliceValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesCall(_callback);
        return localVarCall;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> localVarResp = this.getAPIResourcesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listDeviceClassCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeviceClassValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listDeviceClassCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha3DeviceClassList listDeviceClass(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha3DeviceClassList> localVarResp = this.listDeviceClassWithHttpInfo(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3DeviceClassList> listDeviceClassWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listDeviceClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClassList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDeviceClassAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha3DeviceClassList> _callback) throws ApiException {
        Call localVarCall = this.listDeviceClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClassList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNamespacedResourceClaimCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedResourceClaimValidateBeforeCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.listNamespacedResourceClaimCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimList listNamespacedResourceClaim(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimList> localVarResp = this.listNamespacedResourceClaimWithHttpInfo(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimList> listNamespacedResourceClaimWithHttpInfo(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNamespacedResourceClaimAsync(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha3ResourceClaimList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNamespacedResourceClaimTemplateCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedResourceClaimTemplateValidateBeforeCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.listNamespacedResourceClaimTemplateCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplateList listNamespacedResourceClaimTemplate(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplateList> localVarResp = this.listNamespacedResourceClaimTemplateWithHttpInfo(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplateList> listNamespacedResourceClaimTemplateWithHttpInfo(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplateList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNamespacedResourceClaimTemplateAsync(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha3ResourceClaimTemplateList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplateList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listResourceClaimForAllNamespacesCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceclaims";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClaimForAllNamespacesValidateBeforeCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimList listResourceClaimForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimList> localVarResp = this.listResourceClaimForAllNamespacesWithHttpInfo(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimList> listResourceClaimForAllNamespacesWithHttpInfo(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listResourceClaimForAllNamespacesAsync(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha3ResourceClaimList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listResourceClaimTemplateForAllNamespacesCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceclaimtemplates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClaimTemplateForAllNamespacesValidateBeforeCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplateList listResourceClaimTemplateForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplateList> localVarResp = this.listResourceClaimTemplateForAllNamespacesWithHttpInfo(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplateList> listResourceClaimTemplateForAllNamespacesWithHttpInfo(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplateList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listResourceClaimTemplateForAllNamespacesAsync(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha3ResourceClaimTemplateList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplateList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listResourceSliceCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceSliceValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listResourceSliceCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceSliceList listResourceSlice(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha3ResourceSliceList> localVarResp = this.listResourceSliceWithHttpInfo(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceSliceList> listResourceSliceWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceSliceValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSliceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listResourceSliceAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha3ResourceSliceList> _callback) throws ApiException {
        Call localVarCall = this.listResourceSliceValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSliceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchDeviceClassCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchDeviceClassValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchDeviceClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchDeviceClass(Async)");
        }
        Call localVarCall = this.patchDeviceClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1alpha3DeviceClass patchDeviceClass(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1alpha3DeviceClass> localVarResp = this.patchDeviceClassWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3DeviceClass> patchDeviceClassWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchDeviceClassAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha3DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.patchDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNamespacedResourceClaimCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.patchNamespacedResourceClaimCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim patchNamespacedResourceClaim(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.patchNamespacedResourceClaimWithHttpInfo(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> patchNamespacedResourceClaimWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNamespacedResourceClaimAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNamespacedResourceClaimStatusCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimStatusValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        Call localVarCall = this.patchNamespacedResourceClaimStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim patchNamespacedResourceClaimStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.patchNamespacedResourceClaimStatusWithHttpInfo(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> patchNamespacedResourceClaimStatusWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNamespacedResourceClaimStatusAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNamespacedResourceClaimTemplateCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.patchNamespacedResourceClaimTemplateCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplate patchNamespacedResourceClaimTemplate(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplate> localVarResp = this.patchNamespacedResourceClaimTemplateWithHttpInfo(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplate> patchNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNamespacedResourceClaimTemplateAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha3ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchResourceSliceCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchResourceSliceValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchResourceSlice(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchResourceSlice(Async)");
        }
        Call localVarCall = this.patchResourceSliceCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceSlice patchResourceSlice(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1alpha3ResourceSlice> localVarResp = this.patchResourceSliceWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceSlice> patchResourceSliceWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchResourceSliceAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha3ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.patchResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readDeviceClassCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readDeviceClassValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readDeviceClass(Async)");
        }
        Call localVarCall = this.readDeviceClassCall(name, pretty, _callback);
        return localVarCall;
    }

    public V1alpha3DeviceClass readDeviceClass(String name, String pretty) throws ApiException {
        ApiResponse<V1alpha3DeviceClass> localVarResp = this.readDeviceClassWithHttpInfo(name, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3DeviceClass> readDeviceClassWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readDeviceClassValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readDeviceClassAsync(String name, String pretty, ApiCallback<V1alpha3DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.readDeviceClassValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNamespacedResourceClaimCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.readNamespacedResourceClaimCall(name, namespace, pretty, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim readNamespacedResourceClaim(String name, String namespace, String pretty) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.readNamespacedResourceClaimWithHttpInfo(name, namespace, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> readNamespacedResourceClaimWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNamespacedResourceClaimAsync(String name, String namespace, String pretty, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNamespacedResourceClaimStatusCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimStatusValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaimStatus(Async)");
        }
        Call localVarCall = this.readNamespacedResourceClaimStatusCall(name, namespace, pretty, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim readNamespacedResourceClaimStatus(String name, String namespace, String pretty) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.readNamespacedResourceClaimStatusWithHttpInfo(name, namespace, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> readNamespacedResourceClaimStatusWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNamespacedResourceClaimStatusAsync(String name, String namespace, String pretty, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNamespacedResourceClaimTemplateCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.readNamespacedResourceClaimTemplateCall(name, namespace, pretty, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplate readNamespacedResourceClaimTemplate(String name, String namespace, String pretty) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplate> localVarResp = this.readNamespacedResourceClaimTemplateWithHttpInfo(name, namespace, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplate> readNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNamespacedResourceClaimTemplateAsync(String name, String namespace, String pretty, ApiCallback<V1alpha3ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readResourceSliceCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readResourceSliceValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readResourceSlice(Async)");
        }
        Call localVarCall = this.readResourceSliceCall(name, pretty, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceSlice readResourceSlice(String name, String pretty) throws ApiException {
        ApiResponse<V1alpha3ResourceSlice> localVarResp = this.readResourceSliceWithHttpInfo(name, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceSlice> readResourceSliceWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readResourceSliceValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readResourceSliceAsync(String name, String pretty, ApiCallback<V1alpha3ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.readResourceSliceValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceDeviceClassCall(String name, V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3DeviceClass localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/deviceclasses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceDeviceClassValidateBeforeCall(String name, V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceDeviceClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceDeviceClass(Async)");
        }
        Call localVarCall = this.replaceDeviceClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3DeviceClass replaceDeviceClass(String name, V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3DeviceClass> localVarResp = this.replaceDeviceClassWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3DeviceClass> replaceDeviceClassWithHttpInfo(String name, V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceDeviceClassAsync(String name, V1alpha3DeviceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3DeviceClass> _callback) throws ApiException {
        Call localVarCall = this.replaceDeviceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceNamespacedResourceClaimCall(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimValidateBeforeCall(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaim(Async)");
        }
        Call localVarCall = this.replaceNamespacedResourceClaimCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim replaceNamespacedResourceClaim(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.replaceNamespacedResourceClaimWithHttpInfo(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> replaceNamespacedResourceClaimWithHttpInfo(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceNamespacedResourceClaimAsync(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceNamespacedResourceClaimStatusCall(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaims/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimStatusValidateBeforeCall(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        Call localVarCall = this.replaceNamespacedResourceClaimStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaim replaceNamespacedResourceClaimStatus(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceClaim> localVarResp = this.replaceNamespacedResourceClaimStatusWithHttpInfo(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaim> replaceNamespacedResourceClaimStatusWithHttpInfo(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceNamespacedResourceClaimStatusAsync(String name, String namespace, V1alpha3ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceNamespacedResourceClaimTemplateCall(String name, String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceClaimTemplate localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/namespaces/{namespace}/resourceclaimtemplates/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceClaimTemplate replaceNamespacedResourceClaimTemplate(String name, String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceClaimTemplate> localVarResp = this.replaceNamespacedResourceClaimTemplateWithHttpInfo(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceClaimTemplate> replaceNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceNamespacedResourceClaimTemplateAsync(String name, String namespace, V1alpha3ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceResourceSliceCall(String name, V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1alpha3ResourceSlice localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/resourceslices/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceResourceSliceValidateBeforeCall(String name, V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceResourceSlice(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceResourceSlice(Async)");
        }
        Call localVarCall = this.replaceResourceSliceCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1alpha3ResourceSlice replaceResourceSlice(String name, V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1alpha3ResourceSlice> localVarResp = this.replaceResourceSliceWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha3ResourceSlice> replaceResourceSliceWithHttpInfo(String name, V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceResourceSliceAsync(String name, V1alpha3ResourceSlice body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha3ResourceSlice> _callback) throws ApiException {
        Call localVarCall = this.replaceResourceSliceValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3ResourceSlice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

