/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha3AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimConsumerReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.")
public class V1alpha3ResourceClaimStatus {
    public static final String SERIALIZED_NAME_ALLOCATION = "allocation";
    @SerializedName(value="allocation")
    private V1alpha3AllocationResult allocation;
    public static final String SERIALIZED_NAME_DEALLOCATION_REQUESTED = "deallocationRequested";
    @SerializedName(value="deallocationRequested")
    private Boolean deallocationRequested;
    public static final String SERIALIZED_NAME_RESERVED_FOR = "reservedFor";
    @SerializedName(value="reservedFor")
    private List<V1alpha3ResourceClaimConsumerReference> reservedFor = new ArrayList<V1alpha3ResourceClaimConsumerReference>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3ResourceClaimStatus allocation(V1alpha3AllocationResult allocation) {
        this.allocation = allocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha3AllocationResult getAllocation() {
        return this.allocation;
    }

    public void setAllocation(V1alpha3AllocationResult allocation) {
        this.allocation = allocation;
    }

    public V1alpha3ResourceClaimStatus deallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.  This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.  This is an alpha field and requires enabling the DRAControlPlaneController feature gate.")
    public Boolean getDeallocationRequested() {
        return this.deallocationRequested;
    }

    public void setDeallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
    }

    public V1alpha3ResourceClaimStatus reservedFor(List<V1alpha3ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
        return this;
    }

    public V1alpha3ResourceClaimStatus addReservedForItem(V1alpha3ResourceClaimConsumerReference reservedForItem) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList<V1alpha3ResourceClaimConsumerReference>();
        }
        this.reservedFor.add(reservedForItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.  In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.  Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.  There can be at most 32 such reservations. This may get increased in the future, but not reduced.")
    public List<V1alpha3ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor;
    }

    public void setReservedFor(List<V1alpha3ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceClaimStatus v1alpha3ResourceClaimStatus = (V1alpha3ResourceClaimStatus)o;
        return Objects.equals(this.allocation, v1alpha3ResourceClaimStatus.allocation) && Objects.equals(this.deallocationRequested, v1alpha3ResourceClaimStatus.deallocationRequested) && Objects.equals(this.reservedFor, v1alpha3ResourceClaimStatus.reservedFor);
    }

    public int hashCode() {
        return Objects.hash(this.allocation, this.deallocationRequested, this.reservedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceClaimStatus {\n");
        sb.append("    allocation: ").append(this.toIndentedString(this.allocation)).append("\n");
        sb.append("    deallocationRequested: ").append(this.toIndentedString(this.deallocationRequested)).append("\n");
        sb.append("    reservedFor: ").append(this.toIndentedString(this.reservedFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayreservedFor;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3ResourceClaimStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3ResourceClaimStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATION) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATION).isJsonNull()) {
            V1alpha3AllocationResult.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ALLOCATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESERVED_FOR) != null && !jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).isJsonNull() && (jsonArrayreservedFor = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESERVED_FOR)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `reservedFor` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).toString()));
            }
            for (int i = 0; i < jsonArrayreservedFor.size(); ++i) {
                V1alpha3ResourceClaimConsumerReference.validateJsonElement(jsonArrayreservedFor.get(i));
            }
        }
    }

    public static V1alpha3ResourceClaimStatus fromJson(String jsonString) throws IOException {
        return (V1alpha3ResourceClaimStatus)JSON.getGson().fromJson(jsonString, V1alpha3ResourceClaimStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOCATION);
        openapiFields.add(SERIALIZED_NAME_DEALLOCATION_REQUESTED);
        openapiFields.add(SERIALIZED_NAME_RESERVED_FOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3ResourceClaimStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3ResourceClaimStatus.class));
            return new TypeAdapter<V1alpha3ResourceClaimStatus>(){

                public void write(JsonWriter out, V1alpha3ResourceClaimStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3ResourceClaimStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3ResourceClaimStatus.validateJsonElement(jsonElement);
                    return (V1alpha3ResourceClaimStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

