/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1alpha1TypeChecking;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.")
public class V1alpha1ValidatingAdmissionPolicyStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1Condition> conditions = new ArrayList<V1Condition>();
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_TYPE_CHECKING = "typeChecking";
    @SerializedName(value="typeChecking")
    private V1alpha1TypeChecking typeChecking;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha1ValidatingAdmissionPolicyStatus conditions(List<V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1alpha1ValidatingAdmissionPolicyStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conditions represent the latest available observations of a policy's current state.")
    public List<V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1alpha1ValidatingAdmissionPolicyStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The generation observed by the controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1alpha1ValidatingAdmissionPolicyStatus typeChecking(V1alpha1TypeChecking typeChecking) {
        this.typeChecking = typeChecking;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1TypeChecking getTypeChecking() {
        return this.typeChecking;
    }

    public void setTypeChecking(V1alpha1TypeChecking typeChecking) {
        this.typeChecking = typeChecking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ValidatingAdmissionPolicyStatus v1alpha1ValidatingAdmissionPolicyStatus = (V1alpha1ValidatingAdmissionPolicyStatus)o;
        return Objects.equals(this.conditions, v1alpha1ValidatingAdmissionPolicyStatus.conditions) && Objects.equals(this.observedGeneration, v1alpha1ValidatingAdmissionPolicyStatus.observedGeneration) && Objects.equals(this.typeChecking, v1alpha1ValidatingAdmissionPolicyStatus.typeChecking);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.observedGeneration, this.typeChecking);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ValidatingAdmissionPolicyStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    typeChecking: ").append(this.toIndentedString(this.typeChecking)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha1ValidatingAdmissionPolicyStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha1ValidatingAdmissionPolicyStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1Condition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE_CHECKING) != null && !jsonObj.get(SERIALIZED_NAME_TYPE_CHECKING).isJsonNull()) {
            V1alpha1TypeChecking.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE_CHECKING));
        }
    }

    public static V1alpha1ValidatingAdmissionPolicyStatus fromJson(String jsonString) throws IOException {
        return (V1alpha1ValidatingAdmissionPolicyStatus)JSON.getGson().fromJson(jsonString, V1alpha1ValidatingAdmissionPolicyStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiFields.add(SERIALIZED_NAME_TYPE_CHECKING);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha1ValidatingAdmissionPolicyStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha1ValidatingAdmissionPolicyStatus.class));
            return new TypeAdapter<V1alpha1ValidatingAdmissionPolicyStatus>(){

                public void write(JsonWriter out, V1alpha1ValidatingAdmissionPolicyStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha1ValidatingAdmissionPolicyStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha1ValidatingAdmissionPolicyStatus.validateJsonElement(jsonElement);
                    return (V1alpha1ValidatingAdmissionPolicyStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

