/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LeaseCandidateSpec is a specification of a Lease.")
public class V1alpha1LeaseCandidateSpec {
    public static final String SERIALIZED_NAME_BINARY_VERSION = "binaryVersion";
    @SerializedName(value="binaryVersion")
    private String binaryVersion;
    public static final String SERIALIZED_NAME_EMULATION_VERSION = "emulationVersion";
    @SerializedName(value="emulationVersion")
    private String emulationVersion;
    public static final String SERIALIZED_NAME_LEASE_NAME = "leaseName";
    @SerializedName(value="leaseName")
    private String leaseName;
    public static final String SERIALIZED_NAME_PING_TIME = "pingTime";
    @SerializedName(value="pingTime")
    private OffsetDateTime pingTime;
    public static final String SERIALIZED_NAME_PREFERRED_STRATEGIES = "preferredStrategies";
    @SerializedName(value="preferredStrategies")
    private List<String> preferredStrategies = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RENEW_TIME = "renewTime";
    @SerializedName(value="renewTime")
    private OffsetDateTime renewTime;

    public V1alpha1LeaseCandidateSpec binaryVersion(String binaryVersion) {
        this.binaryVersion = binaryVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BinaryVersion is the binary version. It must be in a semver format without leading `v`. This field is required when strategy is \"OldestEmulationVersion\"")
    public String getBinaryVersion() {
        return this.binaryVersion;
    }

    public void setBinaryVersion(String binaryVersion) {
        this.binaryVersion = binaryVersion;
    }

    public V1alpha1LeaseCandidateSpec emulationVersion(String emulationVersion) {
        this.emulationVersion = emulationVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EmulationVersion is the emulation version. It must be in a semver format without leading `v`. EmulationVersion must be less than or equal to BinaryVersion. This field is required when strategy is \"OldestEmulationVersion\"")
    public String getEmulationVersion() {
        return this.emulationVersion;
    }

    public void setEmulationVersion(String emulationVersion) {
        this.emulationVersion = emulationVersion;
    }

    public V1alpha1LeaseCandidateSpec leaseName(String leaseName) {
        this.leaseName = leaseName;
        return this;
    }

    @ApiModelProperty(required=true, value="LeaseName is the name of the lease for which this candidate is contending. This field is immutable.")
    public String getLeaseName() {
        return this.leaseName;
    }

    public void setLeaseName(String leaseName) {
        this.leaseName = leaseName;
    }

    public V1alpha1LeaseCandidateSpec pingTime(OffsetDateTime pingTime) {
        this.pingTime = pingTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PingTime is the last time that the server has requested the LeaseCandidate to renew. It is only done during leader election to check if any LeaseCandidates have become ineligible. When PingTime is updated, the LeaseCandidate will respond by updating RenewTime.")
    public OffsetDateTime getPingTime() {
        return this.pingTime;
    }

    public void setPingTime(OffsetDateTime pingTime) {
        this.pingTime = pingTime;
    }

    public V1alpha1LeaseCandidateSpec preferredStrategies(List<String> preferredStrategies) {
        this.preferredStrategies = preferredStrategies;
        return this;
    }

    public V1alpha1LeaseCandidateSpec addPreferredStrategiesItem(String preferredStrategiesItem) {
        this.preferredStrategies.add(preferredStrategiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="PreferredStrategies indicates the list of strategies for picking the leader for coordinated leader election. The list is ordered, and the first strategy supersedes all other strategies. The list is used by coordinated leader election to make a decision about the final election strategy. This follows as - If all clients have strategy X as the first element in this list, strategy X will be used. - If a candidate has strategy [X] and another candidate has strategy [Y, X], Y supersedes X and strategy Y   will be used. - If a candidate has strategy [X, Y] and another candidate has strategy [Y, X], this is a user error and leader   election will not operate the Lease until resolved. (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.")
    public List<String> getPreferredStrategies() {
        return this.preferredStrategies;
    }

    public void setPreferredStrategies(List<String> preferredStrategies) {
        this.preferredStrategies = preferredStrategies;
    }

    public V1alpha1LeaseCandidateSpec renewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RenewTime is the time that the LeaseCandidate was last updated. Any time a Lease needs to do leader election, the PingTime field is updated to signal to the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate objects are also garbage collected if it has been hours since the last renew. The PingTime field is updated regularly to prevent garbage collection for still active LeaseCandidates.")
    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public void setRenewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1LeaseCandidateSpec v1alpha1LeaseCandidateSpec = (V1alpha1LeaseCandidateSpec)o;
        return Objects.equals(this.binaryVersion, v1alpha1LeaseCandidateSpec.binaryVersion) && Objects.equals(this.emulationVersion, v1alpha1LeaseCandidateSpec.emulationVersion) && Objects.equals(this.leaseName, v1alpha1LeaseCandidateSpec.leaseName) && Objects.equals(this.pingTime, v1alpha1LeaseCandidateSpec.pingTime) && Objects.equals(this.preferredStrategies, v1alpha1LeaseCandidateSpec.preferredStrategies) && Objects.equals(this.renewTime, v1alpha1LeaseCandidateSpec.renewTime);
    }

    public int hashCode() {
        return Objects.hash(this.binaryVersion, this.emulationVersion, this.leaseName, this.pingTime, this.preferredStrategies, this.renewTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1LeaseCandidateSpec {\n");
        sb.append("    binaryVersion: ").append(this.toIndentedString(this.binaryVersion)).append("\n");
        sb.append("    emulationVersion: ").append(this.toIndentedString(this.emulationVersion)).append("\n");
        sb.append("    leaseName: ").append(this.toIndentedString(this.leaseName)).append("\n");
        sb.append("    pingTime: ").append(this.toIndentedString(this.pingTime)).append("\n");
        sb.append("    preferredStrategies: ").append(this.toIndentedString(this.preferredStrategies)).append("\n");
        sb.append("    renewTime: ").append(this.toIndentedString(this.renewTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

